"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSecretHeaders = useSecretHeaders;
var _public = require("@kbn/triggers-actions-ui-plugin/public");
var _reactQuery = require("@kbn/react-query");
var _i18n = require("@kbn/i18n");
var _common = require("../../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useSecretHeaders(connectorId) {
  const {
    http,
    notifications: {
      toasts
    }
  } = (0, _public.useKibana)().services;
  return (0, _reactQuery.useQuery)(['secretHeaders', connectorId], async () => {
    return await http.get(`${_common.INTERNAL_BASE_STACK_CONNECTORS_API_PATH}/${connectorId}/secret_headers`);
  }, {
    enabled: Boolean(connectorId),
    initialData: [],
    refetchOnMount: 'always',
    onError: error => {
      var _error$body;
      toasts.addError((_error$body = error.body) !== null && _error$body !== void 0 && _error$body.message ? new Error(error.body.message) : error, {
        title: _i18n.i18n.translate('xpack.stackConnectors.public.common.errorFetchingSecretHeaders', {
          defaultMessage: 'Error fetching secret headers'
        })
      });
    }
  });
}