"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRequiredMessage = exports.TASK_TYPE = exports.SELECT_PROVIDER = exports.QUERY = exports.PROVIDER_REQUIRED = exports.PROVIDER = exports.INVALID_ACTION = exports.INPUT_TYPE = exports.INPUT_INVALID = exports.INPUT = exports.DOCUMENTATION = exports.COPY_TOOLTIP = exports.COPIED_TOOLTIP = exports.BODY_INVALID = exports.BODY_DESCRIPTION = exports.BODY = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getRequiredMessage = field => {
  return _i18n.i18n.translate('xpack.stackConnectors.components.inference.requiredGenericTextField', {
    defaultMessage: '{field} is required.',
    values: {
      field
    }
  });
};
exports.getRequiredMessage = getRequiredMessage;
const INPUT_INVALID = exports.INPUT_INVALID = _i18n.i18n.translate('xpack.stackConnectors.inference.params.error.invalidInputText', {
  defaultMessage: 'Input does not have a valid Array format.'
});
const INVALID_ACTION = exports.INVALID_ACTION = _i18n.i18n.translate('xpack.stackConnectors.components.inference.invalidActionText', {
  defaultMessage: 'Invalid action name.'
});
const BODY = exports.BODY = _i18n.i18n.translate('xpack.stackConnectors.components.inference.bodyFieldLabel', {
  defaultMessage: 'Body'
});
const INPUT = exports.INPUT = _i18n.i18n.translate('xpack.stackConnectors.components.inference.completionInputLabel', {
  defaultMessage: 'Input'
});
const INPUT_TYPE = exports.INPUT_TYPE = _i18n.i18n.translate('xpack.stackConnectors.components.inference.completionInputTypeLabel', {
  defaultMessage: 'Input type'
});
const QUERY = exports.QUERY = _i18n.i18n.translate('xpack.stackConnectors.components.inference.rerankQueryLabel', {
  defaultMessage: 'Query'
});
const BODY_DESCRIPTION = exports.BODY_DESCRIPTION = _i18n.i18n.translate('xpack.stackConnectors.components.inference.bodyCodeEditorAriaLabel', {
  defaultMessage: 'Code editor'
});
const TASK_TYPE = exports.TASK_TYPE = _i18n.i18n.translate('xpack.stackConnectors.components.inference.taskTypeFieldLabel', {
  defaultMessage: 'Task type'
});
const PROVIDER = exports.PROVIDER = _i18n.i18n.translate('xpack.stackConnectors.components.inference.providerFieldLabel', {
  defaultMessage: 'Provider'
});
const PROVIDER_REQUIRED = exports.PROVIDER_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.components.inference.error.requiredProviderText', {
  defaultMessage: 'Provider is required.'
});
const DOCUMENTATION = exports.DOCUMENTATION = _i18n.i18n.translate('xpack.stackConnectors.components.inference.documentation', {
  defaultMessage: 'Inference API documentation'
});
const SELECT_PROVIDER = exports.SELECT_PROVIDER = _i18n.i18n.translate('xpack.stackConnectors.components.inference.selectProvider', {
  defaultMessage: 'Select a service'
});
const COPY_TOOLTIP = exports.COPY_TOOLTIP = _i18n.i18n.translate('xpack.stackConnectors.components.inference.copy.tooltip', {
  defaultMessage: 'Copy to clipboard'
});
const COPIED_TOOLTIP = exports.COPIED_TOOLTIP = _i18n.i18n.translate('xpack.stackConnectors.components.inference.copied.tooltip', {
  defaultMessage: 'Copied!'
});
const BODY_INVALID = exports.BODY_INVALID = _i18n.i18n.translate('xpack.stackConnectors.components.inference.error.invalidBodyText', {
  defaultMessage: 'The request body is not in a valid JSON format.'
});