"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchIssues = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _use_get_issues = require("./use_get_issues");
var _use_get_single_issue = require("./use_get_single_issue");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/stack_connectors/public/connector_types/jira/search_issues.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SearchIssuesComponent = ({
  selectedValue,
  http,
  toastNotifications,
  actionConnector,
  onChange
}) => {
  const [query, setQuery] = (0, _react.useState)(null);
  const [selectedOptions, setSelectedOptions] = (0, _react.useState)([]);
  const [options, setOptions] = (0, _react.useState)([]);
  const {
    isLoading: isLoadingIssues,
    issues
  } = (0, _use_get_issues.useGetIssues)({
    http,
    toastNotifications,
    actionConnector,
    query
  });
  const {
    isLoading: isLoadingSingleIssue,
    issue: singleIssue
  } = (0, _use_get_single_issue.useGetSingleIssue)({
    http,
    toastNotifications,
    actionConnector,
    id: selectedValue
  });
  (0, _react.useEffect)(() => setOptions(issues.map(issue => ({
    label: issue.title,
    value: issue.key
  }))), [issues]);
  (0, _react.useEffect)(() => {
    if (isLoadingSingleIssue || singleIssue == null) {
      return;
    }
    const singleIssueAsOptions = [{
      label: singleIssue.title,
      value: singleIssue.key
    }];
    setOptions(singleIssueAsOptions);
    setSelectedOptions(singleIssueAsOptions);
  }, [singleIssue, isLoadingSingleIssue]);
  const onSearchChange = (0, _react.useCallback)(searchVal => {
    setQuery(searchVal);
  }, []);
  const onChangeComboBox = (0, _react.useCallback)(changedOptions => {
    setSelectedOptions(changedOptions);
    if (changedOptions[0].value) {
      onChange(changedOptions[0].value);
    }
  }, [onChange]);
  const inputPlaceholder = (0, _react.useMemo)(() => isLoadingIssues || isLoadingSingleIssue ? i18n.SEARCH_ISSUES_LOADING : i18n.SEARCH_ISSUES_PLACEHOLDER, [isLoadingIssues, isLoadingSingleIssue]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    singleSelection: true,
    fullWidth: true,
    placeholder: inputPlaceholder,
    "data-test-subj": 'search-parent-issues',
    "aria-label": i18n.SEARCH_ISSUES_COMBO_BOX_ARIA_LABEL,
    options: options,
    isLoading: isLoadingIssues || isLoadingSingleIssue,
    onSearchChange: onSearchChange,
    selectedOptions: selectedOptions,
    onChange: onChangeComboBox,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 5
    }
  });
};
const SearchIssues = exports.SearchIssues = /*#__PURE__*/(0, _react.memo)(SearchIssuesComponent);