"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.USERNAME_LABEL = exports.USERNAME_INVALID = exports.URL_REQUIRED = exports.URL_LABEL = exports.URL_INVALID = exports.URL_AUTH_BUTTON_LABEL = exports.PASSWORD_REQUIRED = exports.PASSWORD_LABEL = exports.BASIC_AUTH_REQUIRED = exports.BASIC_AUTH_LABEL = exports.BASIC_AUTH_BUTTON_LABEL = exports.BASIC_AUTH_BUTTON_GROUP_LEGEND = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const BASIC_AUTH_LABEL = exports.BASIC_AUTH_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.xmatters.connectorSettingsLabel', {
  defaultMessage: 'Select the authentication method used when setting up the xMatters trigger.'
});
const BASIC_AUTH_REQUIRED = exports.BASIC_AUTH_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.components.xmatters.error.requiredConnectorSettingsText', {
  defaultMessage: 'Authentication method is required.'
});
const BASIC_AUTH_BUTTON_GROUP_LEGEND = exports.BASIC_AUTH_BUTTON_GROUP_LEGEND = _i18n.i18n.translate('xpack.stackConnectors.components.xmatters.basicAuthButtonGroupLegend', {
  defaultMessage: 'Basic Authentication'
});
const URL_LABEL = exports.URL_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.xmatters.urlLabel', {
  defaultMessage: 'Initiation URL'
});
const USERNAME_LABEL = exports.USERNAME_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.xmatters.userTextFieldLabel', {
  defaultMessage: 'Username'
});
const PASSWORD_LABEL = exports.PASSWORD_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.xmatters.passwordTextFieldLabel', {
  defaultMessage: 'Password'
});
const PASSWORD_REQUIRED = exports.PASSWORD_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.components.xmatters.error.requiredPasswordText', {
  defaultMessage: 'Password is required.'
});
const BASIC_AUTH_BUTTON_LABEL = exports.BASIC_AUTH_BUTTON_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.xmatters.basicAuthLabel', {
  defaultMessage: 'Basic Authentication'
});
const URL_AUTH_BUTTON_LABEL = exports.URL_AUTH_BUTTON_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.xmatters.urlAuthLabel', {
  defaultMessage: 'URL Authentication'
});
const URL_REQUIRED = exports.URL_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.components.xmatters.error.requiredUrlText', {
  defaultMessage: 'URL is required.'
});
const URL_INVALID = exports.URL_INVALID = _i18n.i18n.translate('xpack.stackConnectors.components.xmatters.error.invalidUrlTextField', {
  defaultMessage: 'URL is invalid.'
});
const USERNAME_INVALID = exports.USERNAME_INVALID = _i18n.i18n.translate('xpack.stackConnectors.components.xmatters.error.invalidUsernameTextField', {
  defaultMessage: 'Username is invalid.'
});