"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.renderParameterTemplates = void 0;
var _mustache_renderer = require("@kbn/actions-plugin/server/lib/mustache_renderer");
var _constants = require("../../../common/d3security/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const renderParameterTemplates = (logger, params, variables) => {
  if ((params === null || params === void 0 ? void 0 : params.subAction) !== _constants.SUB_ACTION.RUN && (params === null || params === void 0 ? void 0 : params.subAction) !== _constants.SUB_ACTION.TEST) return params;
  return {
    ...params,
    subActionParams: {
      ...params.subActionParams,
      body: (0, _mustache_renderer.renderMustacheString)(logger, params.subActionParams.body, variables, 'json')
    }
  };
};
exports.renderParameterTemplates = renderParameterTemplates;