"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldsAccordion = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react2 = require("@emotion/react");
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/streams_app/public/components/data_management/stream_detail_enrichment/steps/blocks/action/optional_fields_accordion.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const defaultButtonContent = _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.optionalFields', {
  defaultMessage: 'Advanced settings'
});
const StyledEuiAccordion = (0, _styled.default)(_eui.EuiAccordion)`
  .euiAccordion__childWrapper {
    overflow: visible;
  }
`;
const FieldsAccordion = ({
  children,
  buttonContent
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(StyledEuiAccordion, {
    element: "fieldset",
    id: "fieldsAccordion",
    paddingSize: "none",
    buttonContent: buttonContent !== null && buttonContent !== void 0 ? buttonContent : defaultButtonContent,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 33,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    css: (0, _react2.css)`
          border-left: ${euiTheme.border.thin};
          margin-left: ${euiTheme.size.m};
          padding-top: ${euiTheme.size.m};
          padding-left: calc(${euiTheme.size.m} + ${euiTheme.size.xs});
        `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 7
    }
  }, children));
};
exports.FieldsAccordion = FieldsAccordion;