"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WhereBlockConfiguration = exports.WhereBlockConditionEditor = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _streamlang = require("@kbn/streamlang");
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _reactHookForm = require("react-hook-form");
var _react2 = require("@xstate5/react");
var _use_discard_confirm = require("../../../../../../hooks/use_discard_confirm");
var _utils = require("../../../utils");
var _prompt_options = require("./prompt_options");
var _processor_condition_editor = require("../../../processor_condition_editor");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/streams_app/public/components/data_management/stream_detail_enrichment/steps/blocks/where/configuration.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const WhereBlockConfiguration = exports.WhereBlockConfiguration = /*#__PURE__*/(0, _react.forwardRef)((props, ref) => {
  const {
    stepRef
  } = props;
  const step = (0, _react2.useSelector)(stepRef, snapshot => snapshot.context.step);
  const isConfigured = (0, _react2.useSelector)(stepRef, snapshot => snapshot.matches('configured'));
  const canDelete = (0, _react2.useSelector)(stepRef, snapshot => snapshot.can({
    type: 'step.delete'
  }));
  const canSave = (0, _react2.useSelector)(stepRef, snapshot => snapshot.can({
    type: 'step.save'
  }));
  const [defaultValues] = (0, _react.useState)(() => (0, _utils.getFormStateFromWhereStep)(step));
  const hasStepChanges = (0, _react2.useSelector)(stepRef, snapshot => !(0, _lodash.isEqual)(snapshot.context.previousStep, snapshot.context.step));
  const handleCancel = (0, _use_discard_confirm.useDiscardConfirm)(() => stepRef.send({
    type: 'step.cancel'
  }), {
    enabled: hasStepChanges,
    ..._prompt_options.discardChangesPromptOptions
  });
  const handleDelete = (0, _use_discard_confirm.useDiscardConfirm)(() => stepRef.send({
    type: 'step.delete'
  }), {
    enabled: canDelete,
    ..._prompt_options.deleteConditionPromptOptions
  });
  const methods = (0, _reactHookForm.useForm)({
    defaultValues: defaultValues,
    mode: 'onChange'
  });
  const isValid = methods.formState.isValid;
  (0, _react.useEffect)(() => {
    const {
      unsubscribe
    } = methods.watch(value => {
      const {
        whereDefinition
      } = (0, _utils.convertWhereBlockFormStateToConfiguration)(value);
      stepRef.send({
        type: 'step.changeCondition',
        step: whereDefinition
      });
    });
    return () => unsubscribe();
  }, [methods, stepRef]);
  const handleSubmit = () => {
    stepRef.send({
      type: 'step.save'
    });
  };
  return /*#__PURE__*/_react.default.createElement("div", {
    ref: ref,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_reactHookForm.FormProvider, (0, _extends2.default)({}, methods, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    component: "form",
    fullWidth: true,
    onSubmit: methods.handleSubmit(handleSubmit),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(WhereBlockConditionEditor, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 11
    }
  }, canDelete && /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "streamsAppWhereBlockConfigurationDeleteButton",
    color: "danger",
    onClick: handleDelete,
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 17
    }
  }, _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.deleteWhereBlockLabel', {
    defaultMessage: 'Delete condition'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "streamsAppWhereBlockConfigurationCancelButton",
    onClick: handleCancel,
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 17
    }
  }, _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.WhereBlockConfiguration.cancel', {
    defaultMessage: 'Cancel'
  }))), /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "streamsAppConditionConfigurationSaveConditionButton",
    size: "s",
    fill: true,
    onClick: methods.handleSubmit(handleSubmit),
    disabled: !canSave || !isValid,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 17
    }
  }, isConfigured ? _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.WhereBlockConfiguration.confirmUpdateCondition', {
    defaultMessage: 'Update'
  }) : _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.WhereBlockConfiguration.confirmCreateCondition', {
    defaultMessage: 'Create condition'
  })))))));
});
const WhereBlockConditionEditor = () => {
  const {
    field
  } = (0, _reactHookForm.useController)({
    name: 'where',
    rules: {
      validate: value => (0, _streamlang.isCondition)(value)
    }
  });
  if (field.value === undefined) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_processor_condition_editor.ProcessorConditionEditorWrapper, {
    condition: field.value,
    onConditionChange: field.onChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 172,
      columnNumber: 5
    }
  });
};
exports.WhereBlockConditionEditor = WhereBlockConditionEditor;