"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Wrapper = Wrapper;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _react2 = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _streamsSchema = require("@kbn/streams-schema");
var _useAsync = _interopRequireDefault(require("react-use/lib/useAsync"));
var _public = require("@kbn/dataset-quality-plugin/public");
var _calculate_data_quality = require("../../../util/calculate_data_quality");
var _use_streams_doc_counts_fetch = require("../../../hooks/use_streams_doc_counts_fetch");
var _use_streams_privileges = require("../../../hooks/use_streams_privileges");
var _use_stream_detail = require("../../../hooks/use_stream_detail");
var _use_streams_app_router = require("../../../hooks/use_streams_app_router");
var _streams_app_page_template = require("../../streams_app_page_template");
var _stream_badges = require("../../stream_badges");
var _group_stream_controls = require("./group_stream_controls");
var _feedback_button = require("../../feedback_button");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/streams_app/public/components/data_management/stream_detail_management/wrapper.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function Wrapper({
  tabs,
  streamId,
  tab
}) {
  var _countResult$value, _countResult$value$va, _countResult$value$va2, _degradedDocsResult$v, _degradedDocsResult$v2, _degradedDocsResult$v3, _failedDocsResult$val, _failedDocsResult$val2, _failedDocsResult$val3, _tabs$tab;
  const router = (0, _use_streams_app_router.useStreamsAppRouter)();
  const {
    definition
  } = (0, _use_stream_detail.useStreamDetail)();
  const {
    features: {
      groupStreams
    }
  } = (0, _use_streams_privileges.useStreamsPrivileges)();
  const tabMap = Object.fromEntries(Object.entries(tabs).map(([tabName, currentTab]) => {
    return [tabName, {
      href: router.link('/{key}/management/{tab}', {
        path: {
          key: streamId,
          tab: tabName
        }
      }),
      label: currentTab.label,
      content: currentTab.content
    }];
  }));
  const {
    getStreamDocCounts
  } = (0, _use_streams_doc_counts_fetch.useStreamDocCountsFetch)({
    groupTotalCountByTimestamp: false,
    canReadFailureStore: _streamsSchema.Streams.ingest.all.GetResponse.is(definition) ? definition.privileges.read_failure_store : true
  });
  const docCountsFetch = getStreamDocCounts(streamId);
  const countResult = (0, _useAsync.default)(() => docCountsFetch.docCount, [docCountsFetch]);
  const failedDocsResult = (0, _useAsync.default)(() => docCountsFetch.failedDocCount, [docCountsFetch]);
  const degradedDocsResult = (0, _useAsync.default)(() => docCountsFetch.degradedDocCount, [docCountsFetch]);
  const docCount = countResult !== null && countResult !== void 0 && countResult.value ? Number((_countResult$value = countResult.value) === null || _countResult$value === void 0 ? void 0 : (_countResult$value$va = _countResult$value.values) === null || _countResult$value$va === void 0 ? void 0 : (_countResult$value$va2 = _countResult$value$va[0]) === null || _countResult$value$va2 === void 0 ? void 0 : _countResult$value$va2[0]) : 0;
  const degradedDocCount = degradedDocsResult !== null && degradedDocsResult !== void 0 && degradedDocsResult.value ? Number((_degradedDocsResult$v = degradedDocsResult.value) === null || _degradedDocsResult$v === void 0 ? void 0 : (_degradedDocsResult$v2 = _degradedDocsResult$v.values) === null || _degradedDocsResult$v2 === void 0 ? void 0 : (_degradedDocsResult$v3 = _degradedDocsResult$v2[0]) === null || _degradedDocsResult$v3 === void 0 ? void 0 : _degradedDocsResult$v3[0]) : 0;
  const failedDocCount = failedDocsResult !== null && failedDocsResult !== void 0 && failedDocsResult.value ? Number((_failedDocsResult$val = failedDocsResult.value) === null || _failedDocsResult$val === void 0 ? void 0 : (_failedDocsResult$val2 = _failedDocsResult$val.values) === null || _failedDocsResult$val2 === void 0 ? void 0 : (_failedDocsResult$val3 = _failedDocsResult$val2[0]) === null || _failedDocsResult$val3 === void 0 ? void 0 : _failedDocsResult$val3[0]) : 0;
  const quality = (0, _calculate_data_quality.calculateDataQuality)({
    totalDocs: docCount,
    degradedDocs: degradedDocCount,
    failedDocs: failedDocCount
  });
  const isQualityLoading = (countResult === null || countResult === void 0 ? void 0 : countResult.loading) || (failedDocsResult === null || failedDocsResult === void 0 ? void 0 : failedDocsResult.loading) || degradedDocsResult.loading;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiPageHeader, {
    paddingSize: "l",
    bottomBorder: "extended",
    breadcrumbs: [{
      href: router.link('/'),
      text: /*#__PURE__*/_react2.default.createElement(_eui.EuiButtonEmpty, {
        iconType: "arrowLeft",
        size: "s",
        flush: "left",
        "aria-label": _i18n.i18n.translate('xpack.streams.entityDetailViewWithoutParams.breadcrumb', {
          defaultMessage: 'Back to Streams'
        }),
        "data-test-subj": "backToStreamsButton",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 113,
          columnNumber: 15
        }
      }, _i18n.i18n.translate('xpack.streams.entityDetailViewWithoutParams.breadcrumb', {
        defaultMessage: 'Streams'
      }))
    }],
    css: (0, _react.css)`
          background: ${euiTheme.colors.backgroundBasePlain};
        `,
    pageTitle: /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
      direction: "row",
      gutterSize: "s",
      alignItems: "baseline",
      justifyContent: "spaceBetween",
      wrap: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 136,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      alignItems: "baseline",
      wrap: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 143,
        columnNumber: 13
      }
    }, streamId, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      justifyContent: "spaceBetween",
      wrap: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 145,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
      grow: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 146,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 147,
        columnNumber: 19
      }
    }, _streamsSchema.Streams.ingest.all.GetResponse.is(definition) && /*#__PURE__*/_react2.default.createElement(_stream_badges.DiscoverBadgeButton, {
      definition: definition,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 149,
        columnNumber: 23
      }
    }), _streamsSchema.Streams.ClassicStream.GetResponse.is(definition) && /*#__PURE__*/_react2.default.createElement(_stream_badges.ClassicStreamBadge, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 151,
        columnNumber: 74
      }
    }), _streamsSchema.Streams.WiredStream.GetResponse.is(definition) && /*#__PURE__*/_react2.default.createElement(_stream_badges.WiredStreamBadge, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 152,
        columnNumber: 72
      }
    }), _streamsSchema.Streams.ingest.all.GetResponse.is(definition) && /*#__PURE__*/_react2.default.createElement(_stream_badges.LifecycleBadge, {
      lifecycle: definition.effective_lifecycle,
      dataTestSubj: `lifecycleBadge-${streamId}`,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 154,
        columnNumber: 23
      }
    }), /*#__PURE__*/_react2.default.createElement(_public.DatasetQualityIndicator, {
      quality: quality,
      isLoading: isQualityLoading,
      verbose: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 159,
        columnNumber: 21
      }
    }))), (groupStreams === null || groupStreams === void 0 ? void 0 : groupStreams.enabled) && _streamsSchema.Streams.GroupStream.GetResponse.is(definition) && /*#__PURE__*/_react2.default.createElement(_group_stream_controls.GroupStreamControls, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 168,
        columnNumber: 19
      }
    }))), /*#__PURE__*/_react2.default.createElement(_feedback_button.FeedbackButton, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 172,
        columnNumber: 13
      }
    })),
    tabs: Object.entries(tabMap).map(([tabKey, {
      label,
      href
    }]) => ({
      label,
      href,
      isSelected: tab === tabKey
    })),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react2.default.createElement(_streams_app_page_template.StreamsAppPageTemplate.Body, {
    noPadding: tab === 'partitioning' || tab === 'processing',
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 181,
      columnNumber: 7
    }
  }, (_tabs$tab = tabs[tab]) === null || _tabs$tab === void 0 ? void 0 : _tabs$tab.content));
}