"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChildStreamList = ChildStreamList;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _css = require("@emotion/css");
var _react = _interopRequireDefault(require("react"));
var _streamsSchema = require("@kbn/streams-schema");
var _lodash = require("lodash");
var _nested_view = require("../../nested_view");
var _current_stream_entry = require("./current_stream_entry");
var _new_routing_stream_entry = require("./new_routing_stream_entry");
var _idle_routing_stream_entry = require("./idle_routing_stream_entry");
var _edit_routing_stream_entry = require("./edit_routing_stream_entry");
var _stream_routing_state_machine = require("./state_management/stream_routing_state_machine");
var _review_suggestions_form = require("./review_suggestions_form/review_suggestions_form");
var _generate_suggestions_button = require("./review_suggestions_form/generate_suggestions_button");
var _no_suggestions_callout = require("./review_suggestions_form/no_suggestions_callout");
var _use_review_suggestions_form = require("./review_suggestions_form/use_review_suggestions_form");
var _use_timefilter = require("../../../hooks/use_timefilter");
var _use_ai_features = require("../../../hooks/use_ai_features");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/streams_app/public/components/data_management/stream_detail_routing/child_stream_list.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function getReasonDisabledCreateButton(canManageRoutingRules, maxNestingLevel) {
  if (maxNestingLevel) {
    return _i18n.i18n.translate('xpack.streams.streamDetailRouting.rules.maxNestingLevel', {
      defaultMessage: 'You have reached the maximum nesting level for streams. Try to flatten your hierarchy.'
    });
  }
  if (!canManageRoutingRules) {
    return _i18n.i18n.translate('xpack.streams.streamDetailRouting.rules.onlySimulate', {
      defaultMessage: "You don't have sufficient privileges to create new streams, only simulate."
    });
  }
}
function ChildStreamList({
  availableStreams
}) {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    changeRule,
    createNewRule,
    editRule,
    reorderRules
  } = (0, _stream_routing_state_machine.useStreamRoutingEvents)();
  const routingSnapshot = (0, _stream_routing_state_machine.useStreamsRoutingSelector)(snapshot => snapshot);
  const aiFeatures = (0, _use_ai_features.useAIFeatures)();
  const {
    timeState
  } = (0, _use_timefilter.useTimefilter)();
  const {
    fetchSuggestions,
    isLoadingSuggestions,
    suggestions,
    resetForm,
    previewSuggestion,
    acceptSuggestion,
    rejectSuggestion
  } = (0, _use_review_suggestions_form.useReviewSuggestionsForm)();
  const {
    currentRuleId,
    definition,
    routing
  } = routingSnapshot.context;
  const canCreateRoutingRules = routingSnapshot.can({
    type: 'routingRule.create'
  });
  const canReorderRoutingRules = routingSnapshot.can({
    type: 'routingRule.reorder',
    routing
  });
  const canManageRoutingRules = definition.privileges.manage;
  const maxNestingLevel = (0, _streamsSchema.getSegments)(definition.stream.name).length >= _streamsSchema.MAX_NESTING_LEVEL;
  const shouldDisplayCreateButton = definition.privileges.simulate;
  const CreateButtonComponent = aiFeatures && aiFeatures.enabled ? _eui.EuiButtonEmpty : _eui.EuiButton;
  const handlerItemDrag = ({
    source,
    destination
  }) => {
    if (source && destination) {
      const items = (0, _eui.euiDragDropReorder)(routing, source.index, destination.index);
      reorderRules(items);
    }
  };
  const getSuggestionsForStream = connectorId => {
    fetchSuggestions({
      streamName: definition.stream.name,
      connectorId,
      start: timeState.start,
      end: timeState.end
    });
  };
  const renderCreateButton = () => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      alignItems: "flex-start",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 99,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "center",
      alignItems: "center",
      className: (0, _css.css)`
            padding: ${euiTheme.size.l};
            padding-bottom: ${euiTheme.size.xxl};
            flex-grow: 1;
            min-height: 80px;
          `,
      wrap: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 100,
        columnNumber: 9
      }
    }, aiFeatures && aiFeatures.enabled && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 112,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_generate_suggestions_button.GenerateSuggestionButton, {
      size: "s",
      onClick: getSuggestionsForStream,
      isLoading: isLoadingSuggestions,
      aiFeatures: aiFeatures,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 113,
        columnNumber: 15
      }
    }, _i18n.i18n.translate('xpack.streams.streamDetailRouting.childStreamList.suggestPartitions', {
      defaultMessage: 'Suggest partitions with AI'
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 128,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "bottom",
      content: getReasonDisabledCreateButton(canManageRoutingRules, maxNestingLevel),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 129,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(CreateButtonComponent, {
      size: "s",
      "data-test-subj": "streamsAppStreamDetailRoutingAddRuleButton",
      onClick: createNewRule,
      disabled: !canCreateRoutingRules || maxNestingLevel,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 133,
        columnNumber: 15
      }
    }, _i18n.i18n.translate('xpack.streams.streamDetailRouting.addRule', {
      defaultMessage: 'Create partition manually'
    }))))));
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none",
    className: (0, _css.css)`
        overflow: auto;
      `,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 151,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_current_stream_entry.CurrentStreamEntry, {
    definition: definition,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 158,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    className: (0, _css.css)`
          display: flex;
          flex-direction: column;
          overflow-y: auto;
          max-height: calc(100% - 80px);
        `,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 161,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDragDropContext, {
    onDragEnd: handlerItemDrag,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 170,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDroppable, {
    droppableId: "routing_children_reordering",
    spacing: "none",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 171,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 172,
      columnNumber: 13
    }
  }, routing.map((routingRule, pos) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: routingRule.id,
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 174,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDraggable, {
    index: pos,
    isDragDisabled: !canReorderRoutingRules,
    draggableId: routingRule.id,
    hasInteractiveChildren: true,
    customDragHandle: true,
    spacing: "none",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 175,
      columnNumber: 19
    }
  }, (provided, snapshot) => /*#__PURE__*/_react.default.createElement(_nested_view.NestedView, {
    last: pos === routing.length - 1,
    first: pos === 0,
    isBeingDragged: snapshot.isDragging,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 184,
      columnNumber: 23
    }
  }, routingRule.isNew ? /*#__PURE__*/_react.default.createElement(_new_routing_stream_entry.NewRoutingStreamEntry, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 190,
      columnNumber: 27
    }
  }) : currentRuleId === routingRule.id ? /*#__PURE__*/_react.default.createElement(_edit_routing_stream_entry.EditRoutingStreamEntry, {
    onChange: changeRule,
    routingRule: routingRule,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 192,
      columnNumber: 27
    }
  }) : /*#__PURE__*/_react.default.createElement(_idle_routing_stream_entry.IdleRoutingStreamEntry, {
    availableStreams: availableStreams,
    draggableProvided: provided,
    isEditingEnabled: routingSnapshot.can({
      type: 'routingRule.edit',
      id: routingRule.id
    }),
    onEditIconClick: editRule,
    routingRule: routingRule,
    canReorder: canReorderRoutingRules,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 194,
      columnNumber: 27
    }
  })))))))), aiFeatures && aiFeatures.enabled && shouldDisplayCreateButton && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 217,
      columnNumber: 13
    }
  }), suggestions ? (0, _lodash.isEmpty)(suggestions) ? /*#__PURE__*/_react.default.createElement(_no_suggestions_callout.NoSuggestionsCallout, {
    aiFeatures: aiFeatures,
    isLoadingSuggestions: isLoadingSuggestions,
    onDismiss: resetForm,
    onRegenerate: getSuggestionsForStream,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 220,
      columnNumber: 17
    }
  }) : /*#__PURE__*/_react.default.createElement(_review_suggestions_form.ReviewSuggestionsForm, {
    acceptSuggestion: acceptSuggestion,
    aiFeatures: aiFeatures,
    definition: definition,
    isLoadingSuggestions: isLoadingSuggestions,
    onRegenerate: getSuggestionsForStream,
    previewSuggestion: previewSuggestion,
    rejectSuggestion: rejectSuggestion,
    resetForm: resetForm,
    suggestions: suggestions,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 227,
      columnNumber: 17
    }
  }) : null)), shouldDisplayCreateButton && !suggestions && renderCreateButton());
}