"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Bullet = exports.mergeValueLabels = exports.BulletSubtype = void 0;
const __1 = require("..");
const spec_type_1 = require("../../specs/spec_type");
const spec_factory_1 = require("../../state/spec_factory");
const common_1 = require("../../utils/common");
exports.BulletSubtype = Object.freeze({
    vertical: 'vertical',
    horizontal: 'horizontal',
    circle: 'circle',
    halfCircle: 'half-circle',
    twoThirdsCircle: 'two-thirds-circle',
});
const mergeValueLabels = (labels) => (0, common_1.mergePartial)({
    active: 'Active',
    value: 'Value',
    target: 'Target',
}, labels);
exports.mergeValueLabels = mergeValueLabels;
const buildProps = (0, spec_factory_1.buildSFProps)()({
    specType: spec_type_1.SpecType.Series,
    chartType: __1.ChartType.Bullet,
}, {});
const Bullet = function (props) {
    const { defaults, overrides } = buildProps;
    const constraints = {};
    (0, spec_factory_1.useSpecFactory)({
        ...defaults,
        ...(0, common_1.stripUndefined)(props),
        ...overrides,
        ...constraints,
    });
    return null;
};
exports.Bullet = Bullet;
//# sourceMappingURL=spec.js.map