"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getScreenReaderDataSelector = void 0;
const get_goal_chart_data_1 = require("./get_goal_chart_data");
const create_selector_1 = require("../../../../state/create_selector");
const get_accessibility_config_1 = require("../../../../state/selectors/get_accessibility_config");
const get_internal_chart_state_1 = require("../../../../state/selectors/get_internal_chart_state");
exports.getScreenReaderDataSelector = (0, create_selector_1.createCustomCachedSelector)([
    get_goal_chart_data_1.getGoalChartDataSelector,
    get_goal_chart_data_1.getGoalChartLabelsSelector,
    get_internal_chart_state_1.getInternalChartStateSelector,
    get_accessibility_config_1.getA11ySettingsSelector,
    (state) => state,
], (goalChartData, goalChartLabels, internalChartState, a11ySettings, state) => {
    const screenReaderItems = [];
    const chartTypeDescription = internalChartState?.getChartTypeDescription(state);
    if (chartTypeDescription) {
        screenReaderItems.push({
            label: 'Chart type',
            id: a11ySettings.defaultSummaryId,
            value: chartTypeDescription,
        });
    }
    if (goalChartData && !isNaN(goalChartData.maximum)) {
        if (goalChartLabels.majorLabel) {
            screenReaderItems.push({
                label: 'Major label',
                value: goalChartLabels.majorLabel,
            });
        }
        if (goalChartLabels.minorLabel) {
            screenReaderItems.push({
                label: 'Minor label',
                value: goalChartLabels.minorLabel,
            });
        }
        screenReaderItems.push({
            label: 'Minimum',
            value: goalChartData.minimum.toString(),
        }, {
            label: 'Maximum',
            value: goalChartData.maximum.toString(),
        }, {
            label: 'Target',
            value: goalChartData.target?.toString() ?? 'N/A',
        }, {
            label: 'Value',
            value: goalChartData.value.toString(),
        });
    }
    return { screenReaderItems };
});
//# sourceMappingURL=get_screen_reader_data.js.map