"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Numeric = void 0;
exports.configMap = configMap;
class Type {
    dflt;
    reconfigurable;
    documentation;
    constructor(dflt, reconfigurable, documentation) {
        this.dflt = dflt;
        this.reconfigurable = reconfigurable;
        this.documentation = documentation;
    }
}
class Numeric extends Type {
    min;
    max;
    type = 'number';
    constructor({ dflt, min, max, reconfigurable, documentation, }) {
        super(dflt, reconfigurable, documentation);
        this.min = min;
        this.max = max;
    }
}
exports.Numeric = Numeric;
function isGroupConfigItem(item) {
    return item.type === 'group';
}
function configMap(mapper, cfgMetadata) {
    return Object.assign({}, ...Object.entries(cfgMetadata).map(([k, v]) => {
        if (isGroupConfigItem(v)) {
            return { [k]: configMap(mapper, v.values) };
        }
        return { [k]: mapper(v) };
    }));
}
//# sourceMappingURL=config_objects.js.map