"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getSpecFromStore = getSpecFromStore;
function getSpecFromStore(specs, chartType, specType, required) {
    const spec = Object.values(specs).find((spec) => spec.chartType === chartType && spec.specType === specType);
    if (!spec && required)
        throw new Error(`Unable to find spec [${chartType} = ${specType}]`);
    return spec ?? null;
}
//# sourceMappingURL=get_spec_from_store.js.map