"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.ErrorWithCode = void 0;
var tslib_1 = require("tslib");
/**
 * Custom error to report the error message with an additional error code.
 */
var ErrorWithCode = /** @class */ (function (_super) {
    tslib_1.__extends(ErrorWithCode, _super);
    /**
     * Constructor of the error.
     * @param message The error message.
     * @param code The code of the error.
     */
    function ErrorWithCode(message, code) {
        var _this = _super.call(this, message) || this;
        _this.code = code;
        return _this;
    }
    return ErrorWithCode;
}(Error));
exports.ErrorWithCode = ErrorWithCode;
