"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiScreenReaderOnlyStyles = exports.euiScreenReaderOnly = void 0;
var _react = require("@emotion/react");
var _global_styling = require("../../../global_styling");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/*
 * Mixin that hides elements offscreen to only be read by screen reader
 * See https://github.com/elastic/eui/pull/5130 and https://github.com/elastic/eui/pull/5152 for more info
 */
var euiScreenReaderOnly = exports.euiScreenReaderOnly = function euiScreenReaderOnly() {
  return "\n  /* Take the element out of the layout */\n  position: absolute;\n  /* Keep it vertically inline */\n  ".concat((0, _global_styling.logicalCSS)('top', 'auto'), "\n  /* Chrome requires a left value, and Selenium (used by Kibana's FTR) requires an off-screen position for its .getVisibleText() to not register SR-only text */\n  ").concat((0, _global_styling.logicalCSS)('left', '-10000px'), "\n  /* The element must have a size (for some screen readers) */\n  ").concat((0, _global_styling.logicalSizeCSS)('1px', '1px'), "\n  /* But reduce the visible size to nothing */\n  clip: rect(0 0 0 0);\n  clip-path: inset(50%);\n  /* And ensure no overflows occur */\n  overflow: hidden;\n  /* Chrome requires the negative margin to not cause overflows of parent containers */\n  margin: -1px;\n");
};

/*
 * Styles
 */
var euiScreenReaderOnlyStyles = exports.euiScreenReaderOnlyStyles = {
  euiScreenReaderOnly: /*#__PURE__*/(0, _react.css)(euiScreenReaderOnly(), ";label:euiScreenReaderOnly;"),
  'euiScreenReaderOnly-showOnFocus': /*#__PURE__*/(0, _react.css)("&:not(:focus, :active, :focus-within){", euiScreenReaderOnly(), ";};label:euiScreenReaderOnly-showOnFocus;")
};