"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiCollapsibleNavGroupStyles = void 0;
var _react = require("@emotion/react");
var _global_styling = require("../../../global_styling");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var euiCollapsibleNavGroupStyles = exports.euiCollapsibleNavGroupStyles = function euiCollapsibleNavGroupStyles(_ref) {
  var euiTheme = _ref.euiTheme;
  return {
    euiCollapsibleNavGroup: /*#__PURE__*/(0, _react.css)("&:not(:first-child){", (0, _global_styling.logicalCSS)('border-top', euiTheme.border.thin), ";};label:euiCollapsibleNavGroup;"),
    // Background colors
    none: /*#__PURE__*/(0, _react.css)(";label:none;"),
    light: /*#__PURE__*/(0, _react.css)("background-color:", euiTheme.components.collapsibleNavGroupBackground, ";;label:light;"),
    dark: /*#__PURE__*/(0, _react.css)("background-color:", euiTheme.components.collapsibleNavGroupBackgroundDark, ";.euiCollapsibleNavGroup__title,.euiCollapsibleNavGroup__heading,.euiAccordion__arrow{color:", euiTheme.colors.ghost, ";};label:dark;"),
    // Header padding
    isCollapsible: /*#__PURE__*/(0, _react.css)(".euiAccordion__triggerWrapper{padding:", euiTheme.size.base, ";};label:isCollapsible;"),
    notCollapsible: /*#__PURE__*/(0, _react.css)(".euiCollapsibleNavGroup__heading{padding:", euiTheme.size.base, ";};label:notCollapsible;"),
    // Children padding
    childrenWrapper: {
      euiCollapsibleNavGroup__children: /*#__PURE__*/(0, _react.css)("padding:", euiTheme.size.s, ";;label:euiCollapsibleNavGroup__children;"),
      withHeading: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('padding-top', 0), ";;label:withHeading;")
    }
  };
};