"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiQuickSelectPanelStyles = void 0;
var _react = require("@emotion/react");
var _global_styling = require("../../../../global_styling");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var euiQuickSelectPanelStyles = exports.euiQuickSelectPanelStyles = function euiQuickSelectPanelStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  return {
    euiQuickSelectPanel: /*#__PURE__*/(0, _react.css)("&:not(:first-child){", (0, _global_styling.logicalCSS)('border-top', euiTheme.border.thin), " ", (0, _global_styling.logicalCSS)('padding-top', euiTheme.size.m), " ", (0, _global_styling.logicalCSS)('margin-top', euiTheme.size.m), ";};label:euiQuickSelectPanel;"),
    euiQuickSelectPanel__title: /*#__PURE__*/(0, _react.css)("float:left;", (0, _global_styling.logicalCSS)('margin-bottom', euiTheme.size.m), ";;label:euiQuickSelectPanel__title;"),
    euiQuickSelectPanel__section: /*#__PURE__*/(0, _react.css)("clear:both;", (0, _global_styling.logicalCSS)('margin-top', euiTheme.size.s), " ", (0, _global_styling.logicalCSS)('max-height', (0, _global_styling.mathWithUnits)(euiTheme.size.m, function (x) {
      return x * 12;
    })), " overflow:hidden;", (0, _global_styling.logicalCSSWithFallback)('overflow-y', 'auto'), " ", (0, _global_styling.euiScrollBarStyles)(euiThemeContext), " ", (0, _global_styling.euiFontSize)(euiThemeContext, 's'), ";;label:euiQuickSelectPanel__section;")
  };
};