"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiFacetGroupStyles = void 0;
var _react = require("@emotion/react");
var _global_styling = require("../../global_styling");
function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var _ref = process.env.NODE_ENV === "production" ? {
  name: "omnk2l-vertical",
  styles: "flex-direction:column;label:vertical;"
} : {
  name: "omnk2l-vertical",
  styles: "flex-direction:column;label:vertical;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var _ref2 = process.env.NODE_ENV === "production" ? {
  name: "envaaw-horizontal",
  styles: "flex-direction:row;flex-wrap:wrap;label:horizontal;"
} : {
  name: "envaaw-horizontal",
  styles: "flex-direction:row;flex-wrap:wrap;label:horizontal;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var _ref3 = process.env.NODE_ENV === "production" ? {
  name: "1g68sie-euiFacetGroup",
  styles: "display:flex;flex-grow:1;label:euiFacetGroup;"
} : {
  name: "1g68sie-euiFacetGroup",
  styles: "display:flex;flex-grow:1;label:euiFacetGroup;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var euiFacetGroupStyles = exports.euiFacetGroupStyles = function euiFacetGroupStyles(_ref4) {
  var euiTheme = _ref4.euiTheme;
  var gutterSizesMap = {
    none: 0,
    s: euiTheme.size.xs,
    m: euiTheme.size.s,
    l: euiTheme.size.m
  };
  var _getVerticalGutters = function _getVerticalGutters(sizeKey) {
    var size = gutterSizesMap[sizeKey];
    return "gap: ".concat(size, " 0;");
  };
  var _getHorizontalGutters = function _getHorizontalGutters(sizeKey) {
    var size = gutterSizesMap[sizeKey];
    return "\n      gap: ".concat(size, " ").concat((0, _global_styling.mathWithUnits)([size, euiTheme.size.m], function (x, y) {
      return x + y;
    }), ";\n    ");
  };
  return {
    // Base
    euiFacetGroup: _ref3,
    // layouts
    horizontal: _ref2,
    vertical: _ref,
    gutterSizes: {
      vertical: {
        none: /*#__PURE__*/(0, _react.css)(_getVerticalGutters('none'), ";label:none;"),
        s: /*#__PURE__*/(0, _react.css)(_getVerticalGutters('s'), ";label:s;"),
        m: /*#__PURE__*/(0, _react.css)(_getVerticalGutters('m'), ";label:m;"),
        l: /*#__PURE__*/(0, _react.css)(_getVerticalGutters('l'), ";label:l;")
      },
      horizontal: {
        none: /*#__PURE__*/(0, _react.css)(_getHorizontalGutters('none'), ";label:none;"),
        s: /*#__PURE__*/(0, _react.css)(_getHorizontalGutters('s'), ";label:s;"),
        m: /*#__PURE__*/(0, _react.css)(_getHorizontalGutters('m'), ";label:m;"),
        l: /*#__PURE__*/(0, _react.css)(_getHorizontalGutters('l'), ";label:l;")
      }
    }
  };
};