"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiFilterGroupStyles = void 0;
var _react = require("@emotion/react");
var _global_styling = require("../../global_styling");
var _form = require("../form/form.styles");
var _filter_button = require("./filter_button.styles");
function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var _ref = process.env.NODE_ENV === "production" ? {
  name: "ejknuq-fullWidth",
  styles: "display:flex;label:fullWidth;"
} : {
  name: "ejknuq-fullWidth",
  styles: "display:flex;label:fullWidth;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var euiFilterGroupStyles = exports.euiFilterGroupStyles = function euiFilterGroupStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var _euiFormVariables = (0, _form.euiFormVariables)(euiThemeContext),
    backgroundColor = _euiFormVariables.backgroundColor,
    controlHeight = _euiFormVariables.controlHeight,
    controlCompressedHeight = _euiFormVariables.controlCompressedHeight;
  var borderRadius = euiTheme.border.radius.small;
  var borderRadiusCompressed = euiTheme.border.radius.small;
  return {
    euiFilterGroup: /*#__PURE__*/(0, _react.css)("position:relative;display:inline-flex;", (0, _global_styling.logicalCSS)('max-width', '100%'), " overflow:hidden;background-color:", backgroundColor, ";&::after{content:'';position:absolute;inset:0;border:", euiTheme.border.width.thin, " solid ", euiTheme.colors.borderBasePlain, ";border-radius:inherit;pointer-events:none;}>*:not(.euiFilterButton__wrapper, .euiFilterButton){", (0, _filter_button.euiFilterButtonDisplay)(euiThemeContext), ";}.euiPopover>.euiFilterButton{", (0, _global_styling.logicalCSS)('width', '100%'), ";}", (0, _global_styling.euiBreakpoint)(euiThemeContext, ['xs', 's']), "{flex-wrap:wrap;}", (0, _global_styling.euiBreakpoint)(euiThemeContext, ['xs']), "{display:flex;.euiPopover:focus-within{z-index:1;}.euiFilterButton__wrapper{flex-grow:1;}};label:euiFilterGroup;"),
    fullWidth: _ref,
    uncompressed: /*#__PURE__*/(0, _react.css)("border-radius:", borderRadius, ";.euiFilterButton__wrapper{", (0, _global_styling.logicalCSS)('height', controlHeight), ";}.euiFilterButton{", (0, _global_styling.logicalCSS)('height', controlHeight), ";}.euiFilterButton-isToggle{", (0, _global_styling.logicalCSS)('height', (0, _global_styling.mathWithUnits)([controlHeight, euiTheme.size.xxs], function (x, y) {
      return x - 3 * y;
    })), ";};label:uncompressed;"),
    compressed: /*#__PURE__*/(0, _react.css)("border-radius:", borderRadiusCompressed, ";.euiFilterButton{", (0, _global_styling.logicalCSS)('height', (0, _global_styling.mathWithUnits)([controlCompressedHeight, euiTheme.border.width.thin], function (x, y) {
      return x - 2 * y;
    })), ";}.euiFilterButton-isToggle{", (0, _global_styling.logicalCSS)('height', (0, _global_styling.mathWithUnits)([controlCompressedHeight, euiTheme.size.xxs], function (x, y) {
      return x - 3 * y;
    })), ";};label:compressed;"),
    /**
     * Not used in EuiFilterGroup directly, but used by EuiSearchBar and consumers
     * A fixed width is required because of the shift in widths that can be caused
     * by the loading animation that precedes the results.
     */
    euiFilterGroup__popoverPanel: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('width', (0, _global_styling.mathWithUnits)(euiTheme.size.base, function (x) {
      return x * 18;
    })), ";;label:euiFilterGroup__popoverPanel;")
  };
};