"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FLYOUT_TYPES = exports.FLYOUT_SIZES = exports.FLYOUT_SIDES = exports.FLYOUT_PADDING_SIZES = exports.DEFAULT_TYPE = exports.DEFAULT_SIZE = exports.DEFAULT_SIDE = exports.DEFAULT_PUSH_MIN_BREAKPOINT = exports.DEFAULT_PADDING_SIZE = void 0;
exports.isEuiFlyoutSizeNamed = isEuiFlyoutSizeNamed;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/** Allowed flyout render types. */
var FLYOUT_TYPES = exports.FLYOUT_TYPES = ['push', 'overlay'];
/** Type representing a supported flyout render type. */

/** Allowed flyout attachment sides. */
var FLYOUT_SIDES = exports.FLYOUT_SIDES = ['left', 'right'];
/** Type representing a supported flyout side. */

/** Allowed named flyout sizes used by the manager. */
var FLYOUT_SIZES = exports.FLYOUT_SIZES = ['s', 'm', 'l', 'fill'];
/** Type representing a supported named flyout size. */

/** Allowed padding sizes for flyout content. */
var FLYOUT_PADDING_SIZES = exports.FLYOUT_PADDING_SIZES = ['none', 's', 'm', 'l'];
/** Type representing a supported flyout padding size. */

/** Default minimum breakpoint at which push-type flyouts begin to push content. */
var DEFAULT_PUSH_MIN_BREAKPOINT = exports.DEFAULT_PUSH_MIN_BREAKPOINT = 'l';
/** Default flyout type when none is provided. */
var DEFAULT_TYPE = exports.DEFAULT_TYPE = 'overlay';
/** Default side where flyouts anchor when none is provided. */
var DEFAULT_SIDE = exports.DEFAULT_SIDE = 'right';
/** Default named flyout size. */
var DEFAULT_SIZE = exports.DEFAULT_SIZE = 'm';
/** Default padding size inside flyouts. */
var DEFAULT_PADDING_SIZE = exports.DEFAULT_PADDING_SIZE = 'l';

/**
 * Custom type checker for named flyout sizes since the prop
 * `size` can also be CSSProperties['width'] (string | number)
 */
function isEuiFlyoutSizeNamed(value) {
  return FLYOUT_SIZES.includes(value);
}