"use strict";

function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiFlyoutComponent = void 0;
var _react = _interopRequireWildcard(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../services");
var _manager = require("./manager");
var _focus_trap = require("../focus_trap");
var _i18n = require("../i18n");
var _resize_observer = require("../observer/resize_observer");
var _accessibility = require("../accessibility");
var _flyout_close_button = require("./_flyout_close_button");
var _flyout = require("./flyout.styles");
var _component_defaults = require("../provider/component_defaults");
var _const = require("./const");
var _hooks = require("./hooks");
var _flyout_menu = require("./flyout_menu");
var _flyout_overlay = require("./_flyout_overlay");
var _flyout_resize_button = require("./_flyout_resize_button");
var _use_flyout_resizable = require("./use_flyout_resizable");
var _use_flyout_z_index = require("./use_flyout_z_index");
var _flyout_parent_context = require("./flyout_parent_context");
var _selectors = require("./manager/selectors");
var _react2 = require("@emotion/react");
var _excluded = ["className", "children", "as", "hideCloseButton", "flyoutMenuProps", "closeButtonProps", "closeButtonPosition", "onClose", "ownFocus", "side", "size", "paddingSize", "maxWidth", "style", "hasChildBackground", "maskProps", "type", "outsideClickCloses", "pushMinBreakpoint", "pushAnimation", "focusTrapProps", "includeFixedHeadersInFocusTrap", "includeSelectorInFocusTrap", "aria-describedby", "aria-labelledby", "id", "resizable", "minWidth", "onResize", "onAnimationEnd"],
  _excluded2 = ["titleId"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
/* eslint-disable local/i18n */
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _toConsumableArray(r) { return _arrayWithoutHoles(r) || _iterableToArray(r) || _unsupportedIterableToArray(r) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _iterableToArray(r) { if ("undefined" != typeof Symbol && null != r[Symbol.iterator] || null != r["@@iterator"]) return Array.from(r); }
function _arrayWithoutHoles(r) { if (Array.isArray(r)) return _arrayLikeToArray(r); }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t.return && (u = t.return(), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
var defaultElement = 'div';
var EuiFlyoutComponent = exports.EuiFlyoutComponent = /*#__PURE__*/(0, _react.forwardRef)(function (props, ref) {
  var _usePropsWithComponen = (0, _component_defaults.usePropsWithComponentDefaults)('EuiFlyout', props),
    className = _usePropsWithComponen.className,
    children = _usePropsWithComponen.children,
    as = _usePropsWithComponen.as,
    _usePropsWithComponen2 = _usePropsWithComponen.hideCloseButton,
    hideCloseButton = _usePropsWithComponen2 === void 0 ? false : _usePropsWithComponen2,
    _flyoutMenuProps = _usePropsWithComponen.flyoutMenuProps,
    closeButtonProps = _usePropsWithComponen.closeButtonProps,
    _usePropsWithComponen3 = _usePropsWithComponen.closeButtonPosition,
    closeButtonPosition = _usePropsWithComponen3 === void 0 ? 'inside' : _usePropsWithComponen3,
    onClose = _usePropsWithComponen.onClose,
    _usePropsWithComponen4 = _usePropsWithComponen.ownFocus,
    ownFocus = _usePropsWithComponen4 === void 0 ? true : _usePropsWithComponen4,
    _usePropsWithComponen5 = _usePropsWithComponen.side,
    side = _usePropsWithComponen5 === void 0 ? _const.DEFAULT_SIDE : _usePropsWithComponen5,
    _usePropsWithComponen6 = _usePropsWithComponen.size,
    _size = _usePropsWithComponen6 === void 0 ? _const.DEFAULT_SIZE : _usePropsWithComponen6,
    _usePropsWithComponen7 = _usePropsWithComponen.paddingSize,
    paddingSize = _usePropsWithComponen7 === void 0 ? _const.DEFAULT_PADDING_SIZE : _usePropsWithComponen7,
    _usePropsWithComponen8 = _usePropsWithComponen.maxWidth,
    maxWidth = _usePropsWithComponen8 === void 0 ? false : _usePropsWithComponen8,
    style = _usePropsWithComponen.style,
    _usePropsWithComponen9 = _usePropsWithComponen.hasChildBackground,
    hasChildBackground = _usePropsWithComponen9 === void 0 ? false : _usePropsWithComponen9,
    maskProps = _usePropsWithComponen.maskProps,
    _usePropsWithComponen10 = _usePropsWithComponen.type,
    type = _usePropsWithComponen10 === void 0 ? _const.DEFAULT_TYPE : _usePropsWithComponen10,
    outsideClickCloses = _usePropsWithComponen.outsideClickCloses,
    _usePropsWithComponen11 = _usePropsWithComponen.pushMinBreakpoint,
    pushMinBreakpoint = _usePropsWithComponen11 === void 0 ? _const.DEFAULT_PUSH_MIN_BREAKPOINT : _usePropsWithComponen11,
    _usePropsWithComponen12 = _usePropsWithComponen.pushAnimation,
    pushAnimation = _usePropsWithComponen12 === void 0 ? false : _usePropsWithComponen12,
    _focusTrapProps = _usePropsWithComponen.focusTrapProps,
    _usePropsWithComponen13 = _usePropsWithComponen.includeFixedHeadersInFocusTrap,
    includeFixedHeadersInFocusTrap = _usePropsWithComponen13 === void 0 ? true : _usePropsWithComponen13,
    includeSelectorInFocusTrap = _usePropsWithComponen.includeSelectorInFocusTrap,
    _ariaDescribedBy = _usePropsWithComponen['aria-describedby'],
    _ariaLabelledBy = _usePropsWithComponen['aria-labelledby'],
    id = _usePropsWithComponen.id,
    _usePropsWithComponen14 = _usePropsWithComponen.resizable,
    resizable = _usePropsWithComponen14 === void 0 ? false : _usePropsWithComponen14,
    minWidth = _usePropsWithComponen.minWidth,
    onResize = _usePropsWithComponen.onResize,
    onAnimationEnd = _usePropsWithComponen.onAnimationEnd,
    rest = _objectWithoutProperties(_usePropsWithComponen, _excluded);
  var _useEuiThemeCSSVariab = (0, _services.useEuiThemeCSSVariables)(),
    setGlobalCSSVariables = _useEuiThemeCSSVariab.setGlobalCSSVariables;
  var Element = as || defaultElement;
  var maskRef = (0, _react.useRef)(null);

  // Ref for the main flyout element to pass to context
  var internalParentFlyoutRef = (0, _react.useRef)(null);
  var isPushed = (0, _hooks.useIsPushed)({
    type: type,
    pushMinBreakpoint: pushMinBreakpoint
  });
  var currentSession = (0, _manager.useCurrentSession)();
  var isInManagedContext = (0, _manager.useIsInManagedFlyout)();
  var flyoutId = (0, _manager.useFlyoutId)(id);
  var layoutMode = (0, _manager.useFlyoutLayoutMode)();
  var isActiveManagedFlyout = (0, _manager.useIsFlyoutActive)(flyoutId);
  var flyoutManager = (0, _manager.useFlyoutManager)();
  var currentZIndexRef = (0, _selectors.useCurrentFlyoutZIndexRef)();

  // Use a ref to access the latest flyoutManager without triggering effect re-runs
  var flyoutManagerRef = (0, _react.useRef)(flyoutManager);
  (0, _react.useEffect)(function () {
    flyoutManagerRef.current = flyoutManager;
  }, [flyoutManager]);
  (0, _react.useEffect)(function () {
    // Keep track of unmanaged flyouts to properly calculate z-index
    // values for all flyouts
    if (!isInManagedContext) {
      var _flyoutManagerRef$cur;
      (_flyoutManagerRef$cur = flyoutManagerRef.current) === null || _flyoutManagerRef$cur === void 0 || _flyoutManagerRef$cur.addUnmanagedFlyout(flyoutId);
      return function () {
        var _flyoutManagerRef$cur2;
        return (_flyoutManagerRef$cur2 = flyoutManagerRef.current) === null || _flyoutManagerRef$cur2 === void 0 ? void 0 : _flyoutManagerRef$cur2.closeUnmanagedFlyout(flyoutId);
      };
    }
  }, [isInManagedContext, flyoutId]);
  var _useEuiFlyoutResizabl = (0, _use_flyout_resizable.useEuiFlyoutResizable)({
      enabled: resizable,
      minWidth: minWidth,
      maxWidth: typeof maxWidth === 'number' ? maxWidth : 0,
      onResize: onResize,
      side: side,
      size: _size
    }),
    onMouseDownResizableButton = _useEuiFlyoutResizabl.onMouseDown,
    onKeyDownResizableButton = _useEuiFlyoutResizabl.onKeyDown,
    size = _useEuiFlyoutResizabl.size,
    setFlyoutRef = _useEuiFlyoutResizabl.setFlyoutRef;

  /**
   * Setting up the refs on the actual flyout element in order to
   * accommodate for the `isPushed` state by adding padding to the body equal to the width of the element
   */
  var _useState = (0, _react.useState)(null),
    _useState2 = _slicedToArray(_useState, 2),
    resizeRef = _useState2[0],
    setResizeRef = _useState2[1];
  var setRef = (0, _services.useCombinedRefs)([setResizeRef, ref, internalParentFlyoutRef, setFlyoutRef]);
  var _useResizeObserver = (0, _resize_observer.useResizeObserver)(isPushed ? resizeRef : null, 'width'),
    width = _useResizeObserver.width;

  /**
   * Effect for adding push padding to body. Using useLayoutEffect to ensure
   * padding changes happen synchronously before child components render -
   * this is needed to prevent RemoveScrollBar from measuring the body in an
   * inconsistent state during flyout transitions.
   */
  (0, _react.useLayoutEffect)(function () {
    if (!isPushed) {
      return; // Only push-type flyouts manage body padding
    }
    var shouldApplyPadding = !isInManagedContext || isActiveManagedFlyout;
    var paddingSide = side === 'left' ? 'paddingInlineStart' : 'paddingInlineEnd';
    var cssVarName = "--euiPushFlyoutOffset".concat(side === 'left' ? 'InlineStart' : 'InlineEnd');
    var managerSide = side === 'left' ? 'left' : 'right';
    if (shouldApplyPadding) {
      document.body.style[paddingSide] = "".concat(width, "px");
      setGlobalCSSVariables(_defineProperty({}, cssVarName, "".concat(width, "px")));
      // Update manager state if in managed context
      if (isInManagedContext && flyoutManagerRef.current) {
        flyoutManagerRef.current.setPushPadding(managerSide, width);
      }
    } else {
      // Explicitly remove padding when this push flyout becomes inactive
      document.body.style[paddingSide] = '';
      setGlobalCSSVariables(_defineProperty({}, cssVarName, null));
      // Clear manager state if in managed context
      if (isInManagedContext && flyoutManagerRef.current) {
        flyoutManagerRef.current.setPushPadding(managerSide, 0);
      }
    }

    // Cleanup on unmount
    return function () {
      document.body.style[paddingSide] = '';
      setGlobalCSSVariables(_defineProperty({}, cssVarName, null));
      // Clear manager state on unmount if in managed context
      if (isInManagedContext && flyoutManagerRef.current) {
        flyoutManagerRef.current.setPushPadding(managerSide, 0);
      }
    };
  }, [isPushed, isInManagedContext, isActiveManagedFlyout, setGlobalCSSVariables, side, width]);

  /**
   * This class doesn't actually do anything by EUI, but is nice to add for consumers (JIC)
   */
  (0, _react.useEffect)(function () {
    document.body.classList.add('euiBody--hasFlyout');
    return function () {
      // Remove the hasFlyout class when the flyout is unmounted
      document.body.classList.remove('euiBody--hasFlyout');
    };
  }, []);

  // Memoize flyout identification and relationships to prevent race conditions
  var flyoutIdentity = (0, _react.useMemo)(function () {
    if (!flyoutId || !currentSession) {
      return {
        isMainFlyout: false,
        siblingFlyoutId: null,
        hasValidSession: false,
        sessionForWidth: null
      };
    }
    var siblingFlyoutId = currentSession.mainFlyoutId === flyoutId ? currentSession.childFlyoutId : currentSession.mainFlyoutId;
    return {
      siblingFlyoutId: siblingFlyoutId,
      hasValidSession: true,
      sessionForWidth: currentSession
    };
  }, [flyoutId, currentSession]);

  // Destructure for easier use
  var siblingFlyoutId = flyoutIdentity.siblingFlyoutId;
  var hasChildFlyout = (currentSession === null || currentSession === void 0 ? void 0 : currentSession.childFlyoutId) != null;
  var isChildFlyout = isInManagedContext && hasChildFlyout && (currentSession === null || currentSession === void 0 ? void 0 : currentSession.childFlyoutId) === id;
  var shouldCloseOnEscape = (0, _react.useMemo)(function () {
    // Regular flyout - always close on ESC
    if (!isInManagedContext) {
      return true;
    }

    // Managed flyout with no child - close on ESC
    if (!hasChildFlyout) {
      return true;
    }

    // Child flyout - close on ESC
    if (isChildFlyout) {
      return true;
    }

    // Main flyout with child flyout - don't close on ESC
    return false;
  }, [isInManagedContext, hasChildFlyout, isChildFlyout]);

  /**
   * ESC key closes flyout based on flyout hierarchy rules
   */
  var onKeyDown = (0, _react.useCallback)(function (event) {
    if (!isPushed && event.key === _services.keys.ESCAPE && shouldCloseOnEscape) {
      event.preventDefault();
      onClose(event);
    }
  }, [onClose, isPushed, shouldCloseOnEscape]);
  var siblingFlyoutWidth = (0, _manager.useFlyoutWidth)(siblingFlyoutId);
  var managedFlyoutIndex = currentZIndexRef.current;
  if (isInManagedContext && currentSession) {
    managedFlyoutIndex = currentSession.zIndex;
  }
  var _useEuiFlyoutZIndex = (0, _use_flyout_z_index.useEuiFlyoutZIndex)({
      maskProps: maskProps,
      isPushed: isPushed,
      managedFlyoutIndex: managedFlyoutIndex,
      isChildFlyout: isChildFlyout
    }),
    flyoutZIndex = _useEuiFlyoutZIndex.flyoutZIndex,
    maskZIndex = _useEuiFlyoutZIndex.maskZIndex;

  /**
   * Set inline styles
   */
  var inlineStyles = (0, _react.useMemo)(function () {
    var composedStyles = (0, _flyout.composeFlyoutInlineStyles)(size, layoutMode, siblingFlyoutId, siblingFlyoutWidth || null, maxWidth, flyoutZIndex);
    return _objectSpread(_objectSpread({}, style), composedStyles);
  }, [style, size, layoutMode, siblingFlyoutId, siblingFlyoutWidth, maxWidth, flyoutZIndex]);
  var styles = (0, _services.useEuiMemoizedStyles)(_flyout.euiFlyoutStyles);
  var cssStyles = [styles.euiFlyout, styles.paddingSizes[paddingSize], (0, _const.isEuiFlyoutSizeNamed)(size) && styles[size], maxWidth === false && styles.noMaxWidth, isPushed ? styles.push.push : styles.overlay.overlay, isPushed ? styles.push[side] : styles.overlay[side], isPushed && !pushAnimation && styles.push.noAnimation, styles[side]];
  var classes = (0, _classnames.default)('euiFlyout', isChildFlyout && hasChildBackground && 'euiFlyout--hasChildBackground', className);
  var flyoutToggle = (0, _react.useRef)(document.activeElement);
  var _useState3 = (0, _react.useState)([]),
    _useState4 = _slicedToArray(_useState3, 2),
    focusTrapShards = _useState4[0],
    setFocusTrapShards = _useState4[1];
  var focusTrapSelectors = (0, _react.useMemo)(function () {
    var selectors = [];
    if (includeSelectorInFocusTrap) {
      selectors = Array.isArray(includeSelectorInFocusTrap) ? includeSelectorInFocusTrap : [includeSelectorInFocusTrap];
    }
    if (includeFixedHeadersInFocusTrap) {
      selectors.push('.euiHeader[data-fixed-header]');
    }
    return selectors;
  }, [includeSelectorInFocusTrap, includeFixedHeadersInFocusTrap]);

  /**
   * Finds the shards to include in the focus trap by querying by `focusTrapSelectors`.
   *
   * @param shouldAutoFocus Whether to auto-focus the flyout wrapper when the focus trap is activated.
   * This is necessary because when a flyout is toggled from within a shard, the focus trap's `autoFocus`
   * feature doesn't work. This logic manually focuses the flyout as a workaround.
   */
  var findShards = (0, _react.useCallback)(function () {
    var shouldAutoFocus = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;
    if (focusTrapSelectors.length > 0) {
      var shardsEls = focusTrapSelectors.flatMap(function (selector) {
        return Array.from(document.querySelectorAll(selector));
      });
      setFocusTrapShards(Array.from(shardsEls));
      if (shouldAutoFocus) {
        shardsEls.forEach(function (shard) {
          if (shard.contains(flyoutToggle.current)) {
            resizeRef === null || resizeRef === void 0 || resizeRef.focus();
          }
        });
      }
    } else {
      // Clear existing shards if necessary, e.g. switching to `false`
      setFocusTrapShards(function (shards) {
        return shards.length ? [] : shards;
      });
    }
  }, [focusTrapSelectors, resizeRef]);
  (0, _react.useEffect)(function () {
    // Auto-focus should only happen on initial flyout mount (or when the dependencies change)
    // because it snaps focus to the flyout wrapper, which steals it from subsequently focused elements.
    findShards(true);
    var unsubscribe = _services.focusTrapPubSub.subscribe(function () {
      return findShards();
    });
    return unsubscribe;
  }, [findShards]);
  var focusTrapProps = (0, _react.useMemo)(function () {
    return _objectSpread(_objectSpread({}, _focusTrapProps), {}, {
      shards: [].concat(_toConsumableArray(focusTrapShards), _toConsumableArray((_focusTrapProps === null || _focusTrapProps === void 0 ? void 0 : _focusTrapProps.shards) || []))
    });
  }, [_focusTrapProps, focusTrapShards]);

  /*
   * Provide meaningful screen reader instructions/details
   */
  var hasOverlayMask = ownFocus && !isPushed;
  var descriptionId = (0, _services.useGeneratedHtmlId)();
  var ariaDescribedBy = (0, _classnames.default)(descriptionId, _ariaDescribedBy);
  var screenReaderDescription = (0, _react.useMemo)(function () {
    return (0, _react2.jsx)(_accessibility.EuiScreenReaderOnly, null, (0, _react2.jsx)("p", {
      id: descriptionId
    }, hasOverlayMask ? (0, _react2.jsx)(_i18n.EuiI18n, {
      token: "euiFlyout.screenReaderModalDialog",
      default: "You are in a modal dialog. Press Escape or tap/click outside the dialog on the shadowed overlay to close."
    }) : (0, _react2.jsx)(_i18n.EuiI18n, {
      token: "euiFlyout.screenReaderNonModalDialog",
      default: "You are in a non-modal dialog. To close the dialog, press Escape."
    }), ' ', focusTrapShards.length > 0 && (0, _react2.jsx)(_i18n.EuiI18n, {
      token: "euiFlyout.screenReaderFocusTrapShards",
      default: "You can still continue tabbing through other global page landmarks."
    })));
  }, [hasOverlayMask, descriptionId, focusTrapShards.length]);

  /*
   * If the flyout menu is to be rendered, ensure the flyout has aria-labelledby referencing the menu's titleId
   */
  var generatedMenuId = (0, _services.useGeneratedHtmlId)();
  var _ref = _flyoutMenuProps || {},
    _titleId = _ref.titleId,
    flyoutMenuProps = _objectWithoutProperties(_ref, _excluded2);
  var hasMenu = !!_flyoutMenuProps;
  var flyoutMenuId = (0, _react.useMemo)(function () {
    if (!hasMenu) return undefined;
    return _titleId || generatedMenuId;
  }, [hasMenu, _titleId, generatedMenuId]);

  // If the flyout level is LEVEL_MAIN, the title should be hidden by default
  var flyoutMenuHideTitle = (0, _react.useMemo)(function () {
    if (!hasMenu) return undefined;
    if ((_flyoutMenuProps === null || _flyoutMenuProps === void 0 ? void 0 : _flyoutMenuProps.hideTitle) !== undefined) {
      return _flyoutMenuProps.hideTitle;
    }
    return (currentSession === null || currentSession === void 0 ? void 0 : currentSession.mainFlyoutId) === flyoutId;
  }, [hasMenu, _flyoutMenuProps, currentSession, flyoutId]);
  var ariaLabelledBy = (0, _react.useMemo)(function () {
    if (flyoutMenuId) {
      return (0, _classnames.default)(flyoutMenuId, _ariaLabelledBy);
    }
    return _ariaLabelledBy;
  }, [flyoutMenuId, _ariaLabelledBy]);

  /*
   * Trap focus even when `ownFocus={false}`, otherwise closing
   * the flyout won't return focus to the originating button.
   *
   * Set `clickOutsideDisables={true}` when `ownFocus={false}`
   * to allow non-keyboard users the ability to interact with
   * elements outside the flyout.
   *
   * Set `onClickOutside={onClose}` when `ownFocus` and `type` are the defaults,
   * or if `outsideClickCloses={true}` to close on clicks that target
   * (both mousedown and mouseup) the overlay mask.
   */
  var onClickOutside = (0, _react.useCallback)(function (event) {
    // Do not close the flyout for any external click
    if (outsideClickCloses === false) return undefined;
    if (hasOverlayMask) {
      // The overlay mask is present, so only clicks on the mask should close the flyout, regardless of outsideClickCloses
      if (event.target === maskRef.current) return onClose(event);
    } else {
      // No overlay mask is present, so any outside clicks should close the flyout
      if (outsideClickCloses === true) return onClose(event);
    }
    // Otherwise if ownFocus is false and outsideClickCloses is undefined, outside clicks should not close the flyout
    return undefined;
  }, [onClose, hasOverlayMask, outsideClickCloses]);
  var maskCombinedRefs = (0, _services.useCombinedRefs)([maskProps === null || maskProps === void 0 ? void 0 : maskProps.maskRef, maskRef]);

  /**
   * For overlay flyouts in managed contexts, coordinate scroll locking with push flyout state.
   */
  var hasPushPaddingInManager = (0, _manager.useHasPushPadding)();
  var shouldDeferScrollLock = !isPushed && isInManagedContext && hasPushPaddingInManager;
  var shouldUseScrollLock = hasOverlayMask && !shouldDeferScrollLock;
  return (0, _react2.jsx)(_flyout_overlay.EuiFlyoutOverlay, {
    hasOverlayMask: hasOverlayMask,
    isPushed: isPushed,
    maskZIndex: maskZIndex,
    maskProps: _objectSpread(_objectSpread({}, maskProps), {}, {
      maskRef: maskCombinedRefs
    })
  }, (0, _react2.jsx)(_services.EuiWindowEvent, {
    event: "keydown",
    handler: onKeyDown
  }), (0, _react2.jsx)(_focus_trap.EuiFocusTrap, _extends({
    disabled: isPushed,
    scrollLock: shouldUseScrollLock,
    clickOutsideDisables: !ownFocus,
    onClickOutside: onClickOutside
  }, focusTrapProps), (0, _react2.jsx)(Element, _extends({
    className: classes,
    css: cssStyles,
    style: inlineStyles,
    ref: setRef,
    id: id
  }, rest, {
    role: !isPushed ? 'dialog' : rest.role,
    "aria-modal": !isPushed || undefined,
    tabIndex: !isPushed ? 0 : rest.tabIndex,
    "aria-describedby": !isPushed ? ariaDescribedBy : _ariaDescribedBy,
    "aria-labelledby": ariaLabelledBy,
    "data-autofocus": !isPushed || undefined,
    onAnimationEnd: onAnimationEnd
  }), !isPushed && screenReaderDescription, !_flyoutMenuProps && !hideCloseButton && (0, _react2.jsx)(_flyout_close_button.EuiFlyoutCloseButton, _extends({}, closeButtonProps, {
    onClose: onClose,
    closeButtonPosition: closeButtonPosition,
    side: side
  })), _flyoutMenuProps && (0, _react2.jsx)(_flyout_menu.EuiFlyoutMenu, _extends({}, flyoutMenuProps, {
    hideTitle: flyoutMenuHideTitle,
    titleId: flyoutMenuId
  })), resizable && (0, _react2.jsx)(_flyout_resize_button.EuiFlyoutResizeButton, {
    type: type,
    side: side,
    ownFocus: ownFocus,
    isPushed: isPushed,
    onMouseDown: onMouseDownResizableButton,
    onTouchStart: onMouseDownResizableButton,
    onKeyDown: onKeyDownResizableButton
  }), (0, _react2.jsx)(_flyout_parent_context.EuiFlyoutParentProvider, null, children))));
}
// React.forwardRef interferes with the inferred element type
// Casting to ensure correct element prop type checking for `as`
// e.g., `href` is not on a `div`
);
// Recast to allow `displayName`
EuiFlyoutComponent.displayName = 'EuiFlyoutComponent';