"use strict";

function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiFlyoutMenu = void 0;
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _react = _interopRequireWildcard(require("react"));
var _services = require("../../services");
var _button = require("../button");
var _flex = require("../flex");
var _list_group = require("../list_group");
var _popover = require("../popover");
var _title = require("../title");
var _flyout_close_button = require("./_flyout_close_button");
var _flyout_menu = require("./flyout_menu.styles");
var _flyout_menu_context = require("./flyout_menu_context");
var _i18n = require("../i18n");
var _react2 = require("@emotion/react");
var _excluded = ["className", "title", "titleId", "hideTitle", "hideCloseButton", "historyItems", "showBackButton", "backButtonProps", "customActions"];
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t.return && (u = t.return(), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */ /**
 * History item for the flyout menu history popover
 */ /**
 * Custom action item for the flyout menu component
 */ /**
 * Props for EuiFlyoutMenu
 */
var BackButton = function BackButton(props) {
  return (0, _react2.jsx)(_button.EuiButtonEmpty, _extends({
    size: "xs",
    color: "text",
    iconType: "editorUndo"
  }, props), (0, _react2.jsx)(_i18n.EuiI18n, {
    token: "euiFlyoutMenu.back",
    default: "Back"
  }));
};
var HistoryPopover = function HistoryPopover(_ref) {
  var items = _ref.items;
  var _useState = (0, _react.useState)(false),
    _useState2 = _slicedToArray(_useState, 2),
    isPopoverOpen = _useState2[0],
    setIsPopoverOpen = _useState2[1];
  var handlePopoverButtonClick = function handlePopoverButtonClick() {
    setIsPopoverOpen(!isPopoverOpen);
  };
  return (0, _react2.jsx)(_popover.EuiPopover, {
    button: (0, _react2.jsx)(_button.EuiButtonIcon, {
      iconType: "arrowDown",
      color: "text",
      "aria-label": (0, _i18n.useEuiI18n)('euiFlyoutMenu.history', 'History')
    }),
    isOpen: isPopoverOpen,
    onClick: handlePopoverButtonClick,
    closePopover: function closePopover() {
      return setIsPopoverOpen(false);
    },
    panelPaddingSize: "xs",
    anchorPosition: "downLeft"
  }, (0, _react2.jsx)(_list_group.EuiListGroup, {
    gutterSize: "none"
  }, items.map(function (item, index) {
    return (0, _react2.jsx)(_list_group.EuiListGroupItem, {
      key: "history-item-".concat(index),
      label: item.title,
      size: "s",
      onClick: function onClick() {
        item.onClick();
        setIsPopoverOpen(false);
      }
    }, item.title);
  })));
};

/**
 * The component for the top menu bar inside a flyout. Since this is a private
 * component, rendering is controlled using the `flyoutMenuProps` prop on
 * `EuiFlyout`. In managed session flyouts, the Flyout Manager controls a back
 * button and history popover for navigating to different flyout sessions
 * within the managed context.
 *
 * @private
 */
var EuiFlyoutMenu = exports.EuiFlyoutMenu = function EuiFlyoutMenu(_ref2) {
  var className = _ref2.className,
    title = _ref2.title,
    titleId = _ref2.titleId,
    hideTitle = _ref2.hideTitle,
    hideCloseButton = _ref2.hideCloseButton,
    _ref2$historyItems = _ref2.historyItems,
    historyItems = _ref2$historyItems === void 0 ? [] : _ref2$historyItems,
    showBackButton = _ref2.showBackButton,
    backButtonProps = _ref2.backButtonProps,
    customActions = _ref2.customActions,
    rest = _objectWithoutProperties(_ref2, _excluded);
  var _useContext = (0, _react.useContext)(_flyout_menu_context.EuiFlyoutMenuContext),
    onClose = _useContext.onClose;
  var styles = (0, _services.useEuiMemoizedStyles)(_flyout_menu.euiFlyoutMenuStyles);
  var classes = (0, _classnames.default)('euiFlyoutMenu', className);
  var titleNode;
  if (title) {
    titleNode = (0, _react2.jsx)(_title.EuiTitle, {
      size: "xxs",
      id: titleId
    }, (0, _react2.jsx)("h3", {
      css: hideTitle && styles.euiFlyoutMenu__hiddenTitle
    }, title));
  }
  var handleClose = function handleClose(event) {
    onClose === null || onClose === void 0 || onClose(event);
  };
  var closeButton = (0, _react2.jsx)(_flyout_close_button.EuiFlyoutCloseButton, {
    onClose: handleClose,
    side: "right",
    closeButtonPosition: "inside"
  });
  return (0, _react2.jsx)("div", _extends({
    className: classes,
    css: styles.euiFlyoutMenu__container
  }, rest), (0, _react2.jsx)(_flex.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "spaceBetween",
    gutterSize: "none",
    responsive: false
  }, showBackButton && (0, _react2.jsx)(_flex.EuiFlexItem, {
    grow: false
  }, (0, _react2.jsx)(BackButton, backButtonProps)), historyItems.length > 0 && (0, _react2.jsx)(_flex.EuiFlexItem, {
    grow: false
  }, (0, _react2.jsx)(HistoryPopover, {
    items: historyItems
  })), titleNode && (0, _react2.jsx)(_flex.EuiFlexItem, {
    grow: false
  }, titleNode), (0, _react2.jsx)(_flex.EuiFlexItem, {
    grow: true
  }), customActions && customActions.map(function (action, actionIndex) {
    return (0, _react2.jsx)(_flex.EuiFlexItem, {
      grow: false,
      key: "action-index-flex-item-".concat(actionIndex),
      css: styles.euiFlyoutMenu__actions
    }, (0, _react2.jsx)(_button.EuiButtonIcon, {
      key: "action-index-icon-".concat(actionIndex),
      "aria-label": action['aria-label'],
      iconType: action.iconType,
      onClick: action.onClick,
      color: "text",
      size: "s"
    }));
  }), !hideCloseButton && (0, _react2.jsx)(_flex.EuiFlexItem, {
    grow: false,
    css: styles.euiFlyoutMenu__spacer
  })), !hideCloseButton && closeButton);
};
EuiFlyoutMenu.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,
  /**
       * An id to use for the title element. Useful for setting aria-labelledby on the flyout.
       * Example:
       * ```jsx
       * <EuiFlyout
       *   aria-labelledby="myMenuTitleId"
       *   flyoutMenuProps={{ title: 'Menu title', titleId: 'myMenuTitleId' }
       * >
       *  ...
       * </EuiFlyout>
       * ```
       */
  titleId: _propTypes.default.string,
  /**
       * Title for the menu component. In a managed flyout context, the title is used to indicate the flyout session for history navigation.
       */
  title: _propTypes.default.node,
  /**
       * Hides the title in the `EuiFlyoutMenu`. This is useful when the title is already shown in an `EuiFlyoutHeader`.
       * @default true for main flyout in a managed flyout session; false otherwise
       */
  hideTitle: _propTypes.default.bool,
  /**
       * Hides the close button in the menu component
       * @default false
       */
  hideCloseButton: _propTypes.default.bool,
  /**
       * Shows a back button in the menu component
       * @default false
       */
  showBackButton: _propTypes.default.bool,
  /**
       * Props to pass to the back button, such as `onClick` handler
       */
  backButtonProps: _propTypes.default.any,
  /**
       * List of history items for the history popover
       */
  historyItems: _propTypes.default.arrayOf(_propTypes.default.shape({
    /**
       * Title for the history item
       */
    title: _propTypes.default.string.isRequired,
    /**
       * onClick handler for the history item
       */
    onClick: _propTypes.default.func.isRequired
  }).isRequired),
  /**
       * List of custom action items for the menu component
       */
  customActions: _propTypes.default.arrayOf(_propTypes.default.shape({
    /**
       * Icon type for the action button
       */
    iconType: _propTypes.default.string.isRequired,
    /**
       * onClick handler for the action button
       */
    onClick: _propTypes.default.func.isRequired,
    /**
       * Aria label for the action button
       */
    "aria-label": _propTypes.default.string.isRequired
  }).isRequired)
};