"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useIsPushed = void 0;
var _services = require("../../services");
var _component_defaults = require("../provider/component_defaults");
var _const = require("./const");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Determines if a flyout should be rendered in a "pushed" state based on its
 * configuration and the current window size.
 */
var useIsPushed = exports.useIsPushed = function useIsPushed(props) {
  var _usePropsWithComponen = (0, _component_defaults.usePropsWithComponentDefaults)('EuiFlyout', props),
    _usePropsWithComponen2 = _usePropsWithComponen.type,
    type = _usePropsWithComponen2 === void 0 ? _const.DEFAULT_TYPE : _usePropsWithComponen2,
    _usePropsWithComponen3 = _usePropsWithComponen.pushMinBreakpoint,
    pushMinBreakpoint = _usePropsWithComponen3 === void 0 ? _const.DEFAULT_PUSH_MIN_BREAKPOINT : _usePropsWithComponen3;
  var windowIsLargeEnoughToPush = (0, _services.useIsWithinMinBreakpoint)(pushMinBreakpoint);
  return type === 'push' && windowIsLargeEnoughToPush;
};