"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setPushPadding = exports.setLayoutMode = exports.setFlyoutWidth = exports.setActivityStage = exports.setActiveFlyout = exports.goToFlyout = exports.goBack = exports.closeUnmanagedFlyout = exports.closeFlyout = exports.addUnmanagedFlyout = exports.addFlyout = exports.ACTION_SET_WIDTH = exports.ACTION_SET_PUSH_PADDING = exports.ACTION_SET_LAYOUT_MODE = exports.ACTION_SET_ACTIVITY_STAGE = exports.ACTION_SET_ACTIVE = exports.ACTION_GO_TO_FLYOUT = exports.ACTION_GO_BACK = exports.ACTION_CLOSE_UNMANAGED_FLYOUT = exports.ACTION_CLOSE = exports.ACTION_ADD_UNMANAGED_FLYOUT = exports.ACTION_ADD = void 0;
var _const = require("./const");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var PREFIX = 'eui/flyoutManager';
/** Dispatched when a flyout registers itself with the manager. */
var ACTION_ADD = exports.ACTION_ADD = "".concat(PREFIX, "/add");
/** Dispatched to remove a flyout from the manager (usually on close/unmount). */
var ACTION_CLOSE = exports.ACTION_CLOSE = "".concat(PREFIX, "/close");
/** Dispatched to set which flyout is currently active within the session. */
var ACTION_SET_ACTIVE = exports.ACTION_SET_ACTIVE = "".concat(PREFIX, "/setActive");
/** Dispatched when an active flyout's pixel width changes (for responsive layout). */
var ACTION_SET_WIDTH = exports.ACTION_SET_WIDTH = "".concat(PREFIX, "/setWidth");
/** Dispatched to switch layout mode between `side-by-side` and `stacked`. */
var ACTION_SET_LAYOUT_MODE = exports.ACTION_SET_LAYOUT_MODE = "".concat(PREFIX, "/setLayoutMode");
/** Dispatched to update a flyout's activity stage (e.g., opening -> active). */
var ACTION_SET_ACTIVITY_STAGE = exports.ACTION_SET_ACTIVITY_STAGE = "".concat(PREFIX, "/setActivityStage");
/** Dispatched to go back one session (remove current session). */
var ACTION_GO_BACK = exports.ACTION_GO_BACK = "".concat(PREFIX, "/goBack");
/** Dispatched to navigate to a specific flyout (remove all sessions after it). */
var ACTION_GO_TO_FLYOUT = exports.ACTION_GO_TO_FLYOUT = "".concat(PREFIX, "/goToFlyout");
/** Dispatched to set push padding offset for a side. */
var ACTION_SET_PUSH_PADDING = exports.ACTION_SET_PUSH_PADDING = "".concat(PREFIX, "/setPushPadding");
var ACTION_ADD_UNMANAGED_FLYOUT = exports.ACTION_ADD_UNMANAGED_FLYOUT = "".concat(PREFIX, "/addUnmanagedFlyout");
var ACTION_CLOSE_UNMANAGED_FLYOUT = exports.ACTION_CLOSE_UNMANAGED_FLYOUT = "".concat(PREFIX, "/closeUnmanagedFlyout");

/**
 * Add a flyout to manager state. The manager will create or update
 * the current session depending on the `level` provided.
 */

/** Remove a flyout from manager state. Also updates the active session. */

/** Set the active flyout within the current session (or clear with `null`). */

/** Update a flyout's measured width in pixels. */

/** Change how flyouts are arranged: `side-by-side` or `stacked`. */

/** Set a specific flyout's activity stage. */

/** Go back one session (remove current session from stack). */

/** Navigate to a specific flyout (remove all sessions after it). */

/** Set push padding offset for a specific side. */

/** Union of all flyout manager actions. */

/**
 * Register a flyout with the manager.
 * - `title` is used for the flyout menu.
 * - `level` determines whether the flyout is `main` or `child`.
 * - Optional `size` is the named EUI size (e.g. `s`, `m`, `l`).
 */
var addFlyout = exports.addFlyout = function addFlyout(flyoutId, title) {
  var level = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : _const.LEVEL_MAIN;
  var size = arguments.length > 3 ? arguments[3] : undefined;
  return {
    type: ACTION_ADD,
    flyoutId: flyoutId,
    title: title,
    level: level,
    size: size
  };
};

/** Unregister a flyout and update the session accordingly. */
var closeFlyout = exports.closeFlyout = function closeFlyout(flyoutId) {
  return {
    type: ACTION_CLOSE,
    flyoutId: flyoutId
  };
};

/** Set or clear the active flyout for the current session. */
var setActiveFlyout = exports.setActiveFlyout = function setActiveFlyout(flyoutId) {
  return {
    type: ACTION_SET_ACTIVE,
    flyoutId: flyoutId
  };
};

/** Record a flyout's current width in pixels. */
var setFlyoutWidth = exports.setFlyoutWidth = function setFlyoutWidth(flyoutId, width) {
  return {
    type: ACTION_SET_WIDTH,
    flyoutId: flyoutId,
    width: width
  };
};

/** Switch layout mode between `side-by-side` and `stacked`. */
var setLayoutMode = exports.setLayoutMode = function setLayoutMode(layoutMode) {
  return {
    type: ACTION_SET_LAYOUT_MODE,
    layoutMode: layoutMode
  };
};

/** Update a flyout's activity stage. */
var setActivityStage = exports.setActivityStage = function setActivityStage(flyoutId, activityStage) {
  return {
    type: ACTION_SET_ACTIVITY_STAGE,
    flyoutId: flyoutId,
    activityStage: activityStage
  };
};

/** Go back one session (remove current session from stack). */
var goBack = exports.goBack = function goBack() {
  return {
    type: ACTION_GO_BACK
  };
};

/** Navigate to a specific flyout (remove all sessions after it). */
var goToFlyout = exports.goToFlyout = function goToFlyout(flyoutId) {
  return {
    type: ACTION_GO_TO_FLYOUT,
    flyoutId: flyoutId
  };
};

/** Set push padding offset for a specific side. */
var setPushPadding = exports.setPushPadding = function setPushPadding(side, width) {
  return {
    type: ACTION_SET_PUSH_PADDING,
    side: side,
    width: width
  };
};

/** Register an unmanaged flyout for z-index positioning purposes */
var addUnmanagedFlyout = exports.addUnmanagedFlyout = function addUnmanagedFlyout(flyoutId) {
  return {
    type: ACTION_ADD_UNMANAGED_FLYOUT,
    flyoutId: flyoutId
  };
};

/** Unregister an unmanaged flyout */
var closeUnmanagedFlyout = exports.closeUnmanagedFlyout = function closeUnmanagedFlyout(flyoutId) {
  return {
    type: ACTION_CLOSE_UNMANAGED_FLYOUT,
    flyoutId: flyoutId
  };
};