"use strict";

function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useIsInManagedFlyout = exports.EuiFlyoutIsManagedProvider = void 0;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

// Context to track if we're within a managed flyout
var EuiFlyoutIsManagedContext = /*#__PURE__*/(0, _react.createContext)(false);

/**
 * React provider that marks descendants as being rendered inside
 * an EUI managed flyout. Used by hooks/components to alter behavior
 * (e.g., focus handling) when inside a managed flyout tree.
 */
var EuiFlyoutIsManagedProvider = exports.EuiFlyoutIsManagedProvider = function EuiFlyoutIsManagedProvider(_ref) {
  var isManaged = _ref.isManaged,
    children = _ref.children;
  return (0, _react2.jsx)(EuiFlyoutIsManagedContext.Provider, {
    value: isManaged
  }, children);
};

/**
 * Hook that returns `true` when called within an EUI managed flyout subtree.
 */
var useIsInManagedFlyout = exports.useIsInManagedFlyout = function useIsInManagedFlyout() {
  return (0, _react.useContext)(EuiFlyoutIsManagedContext);
};