"use strict";

function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiFlyoutChild = EuiFlyoutChild;
var _react = _interopRequireDefault(require("react"));
var _services = require("../../../services");
var _flyout_managed = require("./flyout_managed");
var _hooks = require("./hooks");
var _const = require("./const");
var _const2 = require("../const");
var _react2 = require("@emotion/react");
var _excluded = ["css", "side"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
/**
 * Props for `EuiFlyoutChild`, a managed child flyout that pairs with a main flyout.
 *
 * Notes:
 * - `type`, `side`, and `level` are fixed by the component and thus omitted.
 */
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
/**
 * Managed child flyout that renders alongside or stacked over the main flyout,
 * depending on the current layout mode. Handles required managed flyout props.
 */
function EuiFlyoutChild(_ref) {
  var customCss = _ref.css,
    _ref$side = _ref.side,
    side = _ref$side === void 0 ? _const2.DEFAULT_SIDE : _ref$side,
    props = _objectWithoutProperties(_ref, _excluded);
  var _useEuiTheme = (0, _services.useEuiTheme)(),
    euiTheme = _useEuiTheme.euiTheme;
  var mainFlyout = (0, _hooks.useCurrentMainFlyout)();
  var mainWidth = (0, _hooks.useFlyoutWidth)(mainFlyout === null || mainFlyout === void 0 ? void 0 : mainFlyout.flyoutId);
  var layoutMode = (0, _hooks.useFlyoutLayoutMode)();

  // Runtime validation: prevent orphan child flyouts
  if (!mainFlyout) {
    var errorMessage = 'EuiFlyoutChild must be used with an EuiFlyoutMain. ' + 'This usually means the main flyout was not rendered before the child flyout.';

    // In development, throw an error to catch the issue early
    if (process.env.NODE_ENV === 'development') {
      throw new Error(errorMessage);
    }

    // In production, log a warning and prevent rendering
    console.error('EuiFlyoutChild validation failed:', errorMessage);
    return null;
  }
  var style = {};
  if (mainWidth && layoutMode === _const.LAYOUT_MODE_SIDE_BY_SIDE) {
    style = _defineProperty({}, side, mainWidth);
  } else if (layoutMode === _const.LAYOUT_MODE_STACKED) {
    style = {
      zIndex: Number(euiTheme.levels.flyout) + 2
    };
  }
  return (0, _react2.jsx)(_flyout_managed.EuiManagedFlyout, _extends({}, props, {
    style: style,
    level: _const.LEVEL_CHILD,
    type: "overlay",
    ownFocus: false,
    side: side,
    css: customCss
  }));
}