"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiManagedFlyoutStyles = void 0;
var _react = require("@emotion/react");
var _global_styling = require("../../../global_styling");
var _const = require("./const");
var _const2 = require("../const");
var _templateObject, _templateObject2;
function _taggedTemplateLiteral(e, t) { return t || (t = e.slice(0)), Object.freeze(Object.defineProperties(e, { raw: { value: Object.freeze(t) } })); }
function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var _ref = process.env.NODE_ENV === "production" ? {
  name: "hklg7q-managedFlyout",
  styles: "perspective:1000px;transform-style:preserve-3d;label:managedFlyout;"
} : {
  name: "hklg7q-managedFlyout",
  styles: "perspective:1000px;transform-style:preserve-3d;label:managedFlyout;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
/**
 * Emotion styles for managed flyouts.
 * Provides base 3D context and animations tied to managed flyout stages
 * via data attributes.
 */
var euiManagedFlyoutStyles = exports.euiManagedFlyoutStyles = function euiManagedFlyoutStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  return {
    stage: function stage(activeStage) {
      var side = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : _const2.DEFAULT_SIDE;
      var level = arguments.length > 2 ? arguments[2] : undefined;
      // Animation for moving flyout backwards in 3D space (z-axis) when inactive
      var euiFlyoutSlideBack3D = (0, _react.keyframes)(_templateObject || (_templateObject = _taggedTemplateLiteral(["\n        from {\n          transform: translateZ(0) translateX(0) scale(1);\n          filter: blur(0px);\n          opacity: 1;\n        }\n        to {\n          transform: translateZ(-1500px) translateX(", ") scale(0.5);\n          filter: blur(3px);\n          opacity: 0.6;\n        }\n      "])), side === 'left' ? 'calc(-100vw - 100%)' : 'calc(100vw + 100%)');

      // Animation for bringing flyout forward from 3D space when transitioning to active
      var euiFlyoutSlideForward3D = (0, _react.keyframes)(_templateObject2 || (_templateObject2 = _taggedTemplateLiteral(["\n        from {\n          transform: translateZ(-500px) translateX(", ") scale(0.85);\n          filter: blur(3px);\n          opacity: 0.6;\n        }\n        to {\n          transform: translateZ(0) translateX(0) scale(1);\n          filter: blur(0px);\n          opacity: 1;\n        }\n      "])), side === 'left' ? 'calc(-100vw - 100%)' : 'calc(100vw + 100%)');
      // When flyout is becoming inactive, animate backwards in 3D space
      var inactiveTransition = /*#__PURE__*/(0, _react.css)(_global_styling.euiCanAnimate, "{animation:", euiFlyoutSlideBack3D, " ", euiTheme.animation.extraSlow, " ", euiTheme.animation.resistance, " forwards;pointer-events:none;};label:inactiveTransition;");

      // When flyout is becoming active from a backgrounded state, animate forward in 3D space
      var returningTransition = /*#__PURE__*/(0, _react.css)(_global_styling.euiCanAnimate, "{animation:", euiFlyoutSlideForward3D, " ", euiTheme.animation.normal, " ", euiTheme.animation.resistance, " forwards;};label:returningTransition;");
      var noTransition = /*#__PURE__*/(0, _react.css)(_global_styling.euiCanAnimate, "{animation:none;opacity:1;};label:noTransition;");
      var activeFlyout = /*#__PURE__*/(0, _react.css)("z-index:", parseInt(euiTheme.levels.flyout) + 1, ";pointer-events:auto;;label:activeFlyout;");
      var inactiveFlyout = /*#__PURE__*/(0, _react.css)(side === 'left' ? (0, _global_styling.logicalCSS)('right', '100vw') : (0, _global_styling.logicalCSS)('left', '100vw'), " transform:translateX(", side === 'left' ? 'calc(-100vw - 100%)' : 'calc(100vw + 100%)', ");;label:inactiveFlyout;");
      switch (activeStage) {
        case _const.STAGE_OPENING:
          // Apply a higher z-index to opening main flyouts for seamless
          // transitions from previously active main flyouts
          return [level === _const.LEVEL_MAIN && activeFlyout];
        case _const.STAGE_ACTIVE:
          return [activeFlyout, noTransition];
        case _const.STAGE_BACKGROUNDING:
          return [inactiveTransition];
        case _const.STAGE_BACKGROUNDED:
          return [inactiveFlyout, noTransition];
        case _const.STAGE_RETURNING:
          return [activeFlyout, returningTransition];
        case _const.STAGE_INACTIVE:
          return [inactiveFlyout, noTransition];
        case _const.STAGE_CLOSING:
          return [inactiveTransition];
      }
    },
    managedFlyout: _ref
  };
};