"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "useCurrentChildFlyout", {
  enumerable: true,
  get: function get() {
    return _selectors.useCurrentChildFlyout;
  }
});
Object.defineProperty(exports, "useCurrentMainFlyout", {
  enumerable: true,
  get: function get() {
    return _selectors.useCurrentMainFlyout;
  }
});
Object.defineProperty(exports, "useCurrentSession", {
  enumerable: true,
  get: function get() {
    return _selectors.useCurrentSession;
  }
});
exports.useFlyoutId = void 0;
Object.defineProperty(exports, "useFlyoutLayoutMode", {
  enumerable: true,
  get: function get() {
    return _layout_mode.useFlyoutLayoutMode;
  }
});
exports.useFlyoutManager = void 0;
Object.defineProperty(exports, "useFlyoutWidth", {
  enumerable: true,
  get: function get() {
    return _selectors.useFlyoutWidth;
  }
});
Object.defineProperty(exports, "useHasActiveSession", {
  enumerable: true,
  get: function get() {
    return _selectors.useHasActiveSession;
  }
});
Object.defineProperty(exports, "useHasChildFlyout", {
  enumerable: true,
  get: function get() {
    return _selectors.useHasChildFlyout;
  }
});
Object.defineProperty(exports, "useHasPushPadding", {
  enumerable: true,
  get: function get() {
    return _selectors.useHasPushPadding;
  }
});
Object.defineProperty(exports, "useIsFlyoutActive", {
  enumerable: true,
  get: function get() {
    return _selectors.useIsFlyoutActive;
  }
});
Object.defineProperty(exports, "useIsInManagedFlyout", {
  enumerable: true,
  get: function get() {
    return _context.useIsInManagedFlyout;
  }
});
Object.defineProperty(exports, "useParentFlyoutSize", {
  enumerable: true,
  get: function get() {
    return _selectors.useParentFlyoutSize;
  }
});
Object.defineProperty(exports, "usePushPaddingOffsets", {
  enumerable: true,
  get: function get() {
    return _selectors.usePushPaddingOffsets;
  }
});
var _react = require("react");
var _services = require("../../../services");
var _provider = require("./provider");
var _selectors = require("./selectors");
var _layout_mode = require("./layout_mode");
var _context = require("./context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

// Ensure uniqueness across multiple hook instances, including in test envs
var autoGeneratedFlyoutIdCounter = 0;
// Convenience selector for a flyout's activity stage

/** Access the flyout manager context (state and actions). */
var useFlyoutManager = exports.useFlyoutManager = function useFlyoutManager() {
  return (0, _react.useContext)(_provider.EuiFlyoutManagerContext);
};

/**
 * Stable flyout ID utility. Uses the passed `id` if provided and not already registered,
 * otherwise generates a deterministic ID for the component's lifetime.
 * The ID remains stable across re-renders to maintain consistency in effects and other hooks.
 */
var useFlyoutId = exports.useFlyoutId = function useFlyoutId(flyoutId) {
  var defaultId = (0, _services.useGeneratedHtmlId)({
    prefix: 'flyout-'
  });
  var isRegistered = (0, _selectors.useIsFlyoutRegistered)(flyoutId);

  // Use ref to maintain ID stability across re-renders
  var componentIdRef = (0, _react.useRef)(undefined);
  if (!componentIdRef.current) {
    // Determine the ID to use
    if (!flyoutId) {
      // No ID provided, generate a new one
      componentIdRef.current = "".concat(defaultId, "-").concat(++autoGeneratedFlyoutIdCounter);
    } else if (isRegistered) {
      // ID is provided but already registered, generate a new one
      (0, _services.warnOnce)("flyout-id-".concat(flyoutId), "Flyout with ID ".concat(flyoutId, " already registered; using new ID ").concat(defaultId));
      componentIdRef.current = "".concat(defaultId, "-").concat(++autoGeneratedFlyoutIdCounter);
    } else {
      // ID is provided and not registered, use it
      componentIdRef.current = flyoutId;
    }
  }
  return componentIdRef.current;
};