"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiFieldSearchStyles = void 0;
var _react = require("@emotion/react");
var _form = require("../form.styles");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var euiFieldSearchStyles = exports.euiFieldSearchStyles = function euiFieldSearchStyles(euiThemeContext) {
  var formStyles = (0, _form.euiFormControlStyles)(euiThemeContext);
  return {
    euiFieldSearch: /*#__PURE__*/(0, _react.css)("-webkit-appearance:textfield;&::-webkit-search-decoration,&::-webkit-search-cancel-button{-webkit-appearance:none;}", formStyles.shared, " &:invalid{", formStyles.invalid, ";}&:focus{", formStyles.focus, ";}&:disabled{", formStyles.disabled, ";}&[readOnly]{", formStyles.readOnly, ";}&:autofill{", formStyles.autoFill, ";};label:euiFieldSearch;"),
    // Skip the css() on the default height to avoid generating a className
    uncompressed: formStyles.uncompressed,
    compressed: /*#__PURE__*/(0, _react.css)(formStyles.compressed, ";label:compressed;"),
    // Skip the css() on the default width to avoid generating a className
    formWidth: formStyles.formWidth,
    fullWidth: /*#__PURE__*/(0, _react.css)(formStyles.fullWidth, ";label:fullWidth;"),
    // Layout modifiers
    inGroup: /*#__PURE__*/(0, _react.css)(formStyles.inGroup, ";label:inGroup;")
  };
};