"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiFormControlLayoutDelimited__input = exports.euiFormControlLayoutDelimited__delimiter = exports.euiFormControlLayoutDelimitedStyles = void 0;
var _react = require("@emotion/react");
var _global_styling = require("../../../global_styling");
var _form = require("../form.styles");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var euiFormControlLayoutDelimitedStyles = exports.euiFormControlLayoutDelimitedStyles = function euiFormControlLayoutDelimitedStyles(euiThemeContext) {
  var highContrastMode = euiThemeContext.highContrastMode;
  var form = (0, _form.euiFormVariables)(euiThemeContext);
  var delimitedStyles = "\n      /* Transition smoothly between disabled/readOnly background color changes */\n      ".concat((0, _form.euiFormControlDefaultShadow)(euiThemeContext, {
    withBorder: !highContrastMode ? true : false,
    withBackground: false
  }), "\n    ").trim();
  return {
    // Appended onto existing `euiFormControlLayout` styles
    delimited: /*#__PURE__*/(0, _react.css)(delimitedStyles, ";label:delimited;"),
    disabled: /*#__PURE__*/(0, _react.css)((0, _form.euiFormControlDisabledStyles)(euiThemeContext), ";label:disabled;"),
    readOnly: /*#__PURE__*/(0, _react.css)((0, _form.euiFormControlReadOnlyStyles)(euiThemeContext), " & .euiFormControlLayoutDelimited__input{--euiFormControlStateColor:transparent;outline:none;box-shadow:none;};label:readOnly;"),
    // Appended onto existing `euiFormControlLayout__childrenWrapper` styles
    childrenWrapper: {
      delimited: /*#__PURE__*/(0, _react.css)("display:flex;", (0, _form.euiFormControlDefaultShadow)(euiThemeContext, {
        withBorder: !highContrastMode,
        withBackground: false
      }), " &:hover{", (0, _form.euiFormControlHoverStyles)(euiThemeContext), " box-shadow:none;.euiFormControlLayoutDelimited__input:not(:focus){outline:none;background-color:transparent;}}>:first-child{", (0, _global_styling.logicalCSS)('border-top-left-radius', 'inherit'), " ", (0, _global_styling.logicalCSS)('border-bottom-left-radius', 'inherit'), ";}>:last-child{", (0, _global_styling.logicalCSS)('border-top-right-radius', 'inherit'), " ", (0, _global_styling.logicalCSS)('border-bottom-right-radius', 'inherit'), ";};label:delimited;"),
      invalid: /*#__PURE__*/(0, _react.css)((0, _form.euiFormControlDefaultShadow)(euiThemeContext, {
        withBorder: false,
        withBackgroundColor: false
      }), "\n          :not(.euiFormControlLayoutDelimited__input, .euiFormControlLayoutDelimited__delimiter) {\n            ".concat((0, _form.euiFormControlInvalidStyles)(euiThemeContext), "\n          }\n\n          &:focus-within {\n            --euiFormControlStateColor: ").concat(form.borderColor, ";\n            --euiFormControlStateHoverColor: ").concat(form.borderHovered, ";\n          }\n\n          .euiFormControlLayoutDelimited__input {\n            background-color: transparent;\n          }\n        "), ";label:invalid;"),
      readOnly: /*#__PURE__*/(0, _react.css)(";label:readOnly;")
    }
  };
};
var euiFormControlLayoutDelimited__delimiter = exports.euiFormControlLayoutDelimited__delimiter = function euiFormControlLayoutDelimited__delimiter(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  return /*#__PURE__*/(0, _react.css)("display:flex;align-self:stretch;flex-grow:0;align-items:center;line-height:1;", (0, _global_styling.logicalCSS)('padding-horizontal', (0, _global_styling.mathWithUnits)([euiTheme.size.xs, euiTheme.size.xxs], function (x, y) {
    return x + y;
  })), ";;label:euiFormControlLayoutDelimited__delimiter;");
};
var euiFormControlLayoutDelimited__input = exports.euiFormControlLayoutDelimited__input = /*#__PURE__*/(0, _react.css)("box-shadow:none;border:none;text-align:center;", (0, _global_styling.logicalCSS)('height', '100%'), ";;label:euiFormControlLayoutDelimited__input;");