"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SIZES = exports.EuiLoadingElastic = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _icon = require("../icon");
var _loading_strings = require("./_loading_strings");
var _loading_elastic = require("./loading_elastic.styles");
var _react2 = require("@emotion/react");
var _excluded = ["size", "className", "aria-label"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
var SIZES = exports.SIZES = ['m', 'l', 'xl', 'xxl'];
var EuiLoadingElastic = exports.EuiLoadingElastic = function EuiLoadingElastic(_ref) {
  var _ref$size = _ref.size,
    size = _ref$size === void 0 ? 'm' : _ref$size,
    className = _ref.className,
    ariaLabel = _ref['aria-label'],
    rest = _objectWithoutProperties(_ref, _excluded);
  var classes = (0, _classnames.default)('euiLoadingElastic', className);
  var defaultLabel = (0, _loading_strings.useLoadingAriaLabel)();
  return (0, _react2.jsx)("span", _extends({
    className: classes,
    css: _loading_elastic.euiLoadingElasticStyles.euiLoadingElastic,
    role: "progressbar",
    "aria-label": ariaLabel || defaultLabel
  }, rest), (0, _react2.jsx)(_icon.EuiIcon, {
    type: "logoElastic",
    size: size
  }));
};
EuiLoadingElastic.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,
  size: _propTypes.default.any
};