"use strict";

function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../services");
var _utils = require("../../utils");
var _button = require("../button");
var _focus_trap = require("../focus_trap");
var _overlay_mask = require("../overlay_mask");
var _i18n = require("../i18n");
var _modal = require("./modal.styles");
var _accessibility = require("../accessibility");
var _react2 = require("@emotion/react");
var _excluded = ["className", "children", "initialFocus", "onClose", "maxWidth", "role", "style", "focusTrapProps", "outsideClickCloses", "aria-describedby"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
var EuiModal = exports.EuiModal = function EuiModal(_ref) {
  var className = _ref.className,
    children = _ref.children,
    initialFocus = _ref.initialFocus,
    onClose = _ref.onClose,
    _ref$maxWidth = _ref.maxWidth,
    maxWidth = _ref$maxWidth === void 0 ? true : _ref$maxWidth,
    _ref$role = _ref.role,
    role = _ref$role === void 0 ? 'dialog' : _ref$role,
    style = _ref.style,
    focusTrapProps = _ref.focusTrapProps,
    _ref$outsideClickClos = _ref.outsideClickCloses,
    outsideClickCloses = _ref$outsideClickClos === void 0 ? false : _ref$outsideClickClos,
    _ariaDescribedBy = _ref['aria-describedby'],
    rest = _objectWithoutProperties(_ref, _excluded);
  var onKeyDown = function onKeyDown(event) {
    if (event.key === _services.keys.ESCAPE) {
      if ((0, _utils.isDOMNode)(event.target) && event.currentTarget.contains(event.target)) {
        event.preventDefault();
        event.stopPropagation();
        onClose(event);
      }
    }
  };
  var maskRef = (0, _react.useRef)(null);
  var onClickOutside = (0, _react.useCallback)(function (event) {
    // The overlay mask is always present
    if (outsideClickCloses === true && event.target === maskRef.current) {
      onClose(event);
    }
    return undefined;
  }, [onClose, outsideClickCloses]);
  var newStyle = style;
  if (typeof maxWidth !== 'boolean') {
    newStyle = _objectSpread(_objectSpread({}, newStyle), {}, {
      maxInlineSize: maxWidth
    });
  }
  var classes = (0, _classnames.default)('euiModal', className);
  var euiTheme = (0, _services.useEuiTheme)();
  var styles = (0, _modal.euiModalStyles)(euiTheme);
  var cssStyles = [styles.euiModal, maxWidth === true && styles.defaultMaxWidth];
  var cssCloseIconStyles = [styles.euiModal__closeIcon];
  var descriptionId = (0, _services.useGeneratedHtmlId)();
  var ariaDescribedBy = (0, _classnames.default)(descriptionId, _ariaDescribedBy);
  var screenReaderDescription = (0, _react2.jsx)(_accessibility.EuiScreenReaderOnly, null, (0, _react2.jsx)("p", {
    id: descriptionId
  }, (0, _react2.jsx)(_i18n.EuiI18n, {
    token: "euiModal.screenReaderModalDialog",
    default: "You are in a modal dialog. Press Escape or tap/click outside the dialog on the shadowed overlay to close."
  })));
  return (0, _react2.jsx)(_overlay_mask.EuiOverlayMask, {
    maskRef: maskRef
  }, (0, _react2.jsx)(_focus_trap.EuiFocusTrap, _extends({}, focusTrapProps, {
    initialFocus: initialFocus,
    scrollLock: true,
    preventScrollOnFocus: true,
    onClickOutside: onClickOutside
  }), (0, _react2.jsx)("div", _extends({
    css: cssStyles,
    className: classes,
    onKeyDown: onKeyDown,
    tabIndex: 0,
    style: newStyle,
    role: role,
    "aria-modal": true,
    "aria-describedby": ariaDescribedBy
  }, rest), children, screenReaderDescription, (0, _react2.jsx)(_i18n.EuiI18n, {
    token: "euiModal.closeModal",
    default: "Closes this modal window"
  }, function (closeModal) {
    return (0, _react2.jsx)(_button.EuiButtonIcon, {
      iconType: "cross",
      onClick: onClose,
      css: cssCloseIconStyles,
      className: "euiModal__closeIcon",
      color: "text",
      "aria-label": closeModal
    });
  }))));
};
EuiModal.propTypes = {
  className: _propTypes.default.string,
  /**
     * ReactNode to render as this component's content
     */
  children: _propTypes.default.node.isRequired,
  onClose: _propTypes.default.func.isRequired,
  /**
     * Sets the max-width of the modal.
     * Set to `true` to use the default (`euiBreakpoints 'm'`),
     * set to `false` to not restrict the width,
     * set to a number for a custom width in px,
     * set to a string for a custom width in custom measurement.
     */
  maxWidth: _propTypes.default.oneOfType([_propTypes.default.bool.isRequired, _propTypes.default.number.isRequired, _propTypes.default.string.isRequired]),
  /**
     * Specifies what element should initially have focus.
     * Can be a DOM node, or a selector string (which will be passed to document.querySelector() to find the DOM node), or a function that returns a DOM node.
     */
  initialFocus: _propTypes.default.oneOfType([_propTypes.default.any.isRequired, _propTypes.default.func.isRequired, _propTypes.default.string.isRequired]),
  /**
     * Identifies a modal dialog to screen readers. Modal dialogs that confirm destructive actions
     * or need a user's attention should use "alertdialog".
     */
  role: _propTypes.default.oneOf(["dialog", "alertdialog"]),
  /**
     * Object of props passed to EuiFocusTrap.
     * `returnFocus` defines the return focus behavior and provides the possibility to check the available target element or opt out of the behavior in favor of manually returning focus
     */
  focusTrapProps: _propTypes.default.any,
  /**
     * Whether clicking outside the modal should close it.
     * @default false
     */
  outsideClickCloses: _propTypes.default.bool
};