"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiSelectableListStyles = void 0;
var _react = require("@emotion/react");
var _css = require("@emotion/css");
var _global_styling = require("../../../global_styling");
var _title = require("../../title/title.styles");
var _selectable_list_item = require("./selectable_list_item.styles");
function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */ // .euiSelectableList__list requires a static vanilla className
// as it's passed down to react-window's virtualization library
var _ref = process.env.NODE_ENV === "production" ? {
  name: "1giu8j5-fullHeight",
  styles: "flex-grow:1;label:fullHeight;"
} : {
  name: "1giu8j5-fullHeight",
  styles: "flex-grow:1;label:fullHeight;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var euiSelectableListStyles = exports.euiSelectableListStyles = function euiSelectableListStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var itemVars = (0, _selectable_list_item.euiSelectableListItemVariables)(euiThemeContext);
  return {
    euiSelectableList: /*#__PURE__*/(0, _react.css)("&:has(:focus-visible){", (0, _global_styling.euiFocusRing)(euiThemeContext, 'outset'), ";};label:euiSelectableList;"),
    fullHeight: _ref,
    bordered: /*#__PURE__*/(0, _react.css)("overflow:hidden;border:", euiTheme.border.thin, ";border-radius:", euiTheme.border.radius.medium, ";;label:bordered;"),
    euiSelectableList__list: /*#__PURE__*/(0, _css.css)((0, _global_styling.euiYScrollWithShadows)(euiThemeContext), " &:focus,&>ul:focus{outline:none;};label:euiSelectableList__list;"),
    euiSelectableList__groupLabel: /*#__PURE__*/(0, _react.css)((0, _title.euiTitle)(euiThemeContext, 'xxxs'), " display:flex;align-items:center;", (0, _global_styling.logicalCSS)('border-bottom', itemVars.border), " ", (0, _global_styling.logicalCSS)('padding-vertical', itemVars.paddingVertical), " ", (0, _global_styling.logicalCSS)('padding-horizontal', itemVars.paddingHorizontal), ";;label:euiSelectableList__groupLabel;")
  };
};