"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.STATUS = exports.EuiStepNumber = void 0;
var _classnames = _interopRequireDefault(require("classnames"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireDefault(require("react"));
var _accessibility = require("../accessibility");
var _icon = require("../icon");
var _loading = require("../loading");
var _services = require("../../services");
var _step_strings = require("./step_strings");
var _step_number = require("./step_number.styles");
var _react2 = require("@emotion/react");
var _excluded = ["className", "status", "number", "titleSize"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
var STATUS = exports.STATUS = ['incomplete', 'disabled', 'loading', 'warning', 'danger', 'complete', 'current'];
var EuiStepNumber = exports.EuiStepNumber = function EuiStepNumber(_ref) {
  var className = _ref.className,
    status = _ref.status,
    number = _ref.number,
    _ref$titleSize = _ref.titleSize,
    titleSize = _ref$titleSize === void 0 ? 's' : _ref$titleSize,
    rest = _objectWithoutProperties(_ref, _excluded);
  var ariaLabelsMap = {
    step: (0, _step_strings.useI18nStep)({
      number: number
    }),
    current: (0, _step_strings.useI18nCurrentStep)({
      number: number
    }),
    incomplete: (0, _step_strings.useI18nIncompleteStep)({
      number: number
    }),
    complete: (0, _step_strings.useI18nCompleteStep)({
      number: number
    }),
    disabled: (0, _step_strings.useI18nDisabledStep)({
      number: number
    }),
    warning: (0, _step_strings.useI18nWarningStep)({
      number: number
    }),
    danger: (0, _step_strings.useI18nErrorsStep)({
      number: number
    }),
    loading: (0, _step_strings.useI18nLoadingStep)({
      number: number
    })
  };
  var classes = (0, _classnames.default)('euiStepNumber', className);
  var styles = (0, _services.useEuiMemoizedStyles)(_step_number.euiStepNumberStyles);
  var cssStyles = [styles.euiStepNumber, styles[titleSize], status && styles[status]];
  var iconStyles = (0, _services.useEuiMemoizedStyles)(_step_number.euiStepNumberContentStyles);
  var content;
  var screenReaderText;
  switch (status) {
    // Loading spinner
    case 'loading':
      {
        var iconSizeMap = {
          none: 'm',
          xs: 'l',
          s: 'xl',
          m: 'xl'
        };
        screenReaderText = ariaLabelsMap.loading;
        content = (0, _react2.jsx)(_loading.EuiLoadingSpinner, {
          className: "euiStepNumber__loader",
          size: iconSizeMap[titleSize]
        });
        break;
      }
    // Statuses with icons
    case 'danger':
    case 'warning':
    case 'complete':
      {
        var cssIconStyles = [iconStyles.euiStepNumber__icon, status === 'warning' ? iconStyles.warning[titleSize] : iconStyles[status],
        // EuiIcon does not support a xxs size so far,
        // we use custom sizing here instead
        titleSize === 'none' && iconStyles[titleSize]];
        var iconTypeMap = {
          danger: 'cross',
          warning: 'warning',
          complete: 'check'
        };
        var _iconSizeMap = {
          xxs: 's',
          xs: 's',
          s: 'm',
          m: 'm'
        };
        content = (0, _react2.jsx)(_icon.EuiIcon, {
          type: iconTypeMap[status],
          "aria-label": ariaLabelsMap[status],
          size: _iconSizeMap[titleSize],
          className: "euiStepNumber__icon",
          css: cssIconStyles
        });
        break;
      }
    // Statuses with numbers
    case 'incomplete':
    case 'current':
    case 'disabled':
    default:
      screenReaderText = ariaLabelsMap[status || 'step'];
      if (titleSize === 'none') {
        break;
      }
      content = (0, _react2.jsx)("span", {
        "aria-hidden": "true",
        className: "euiStepNumber__number"
      }, number);
      break;
  }
  return (0, _react2.jsx)("span", _extends({
    className: classes,
    css: cssStyles
  }, rest), screenReaderText && (0, _react2.jsx)(_accessibility.EuiScreenReaderOnly, null, (0, _react2.jsx)("span", null, screenReaderText)), content);
};
EuiStepNumber.propTypes = {
  /**
     * May replace the number provided in props.number with alternate styling
     */
  status: _propTypes.default.any,
  number: _propTypes.default.number,
  /**
     * Title sizing equivalent to EuiTitle, but only `m`, `s`, `xs`.
     * `none` indicates no step number should be rendered.
     * @default s
     */
  titleSize: _propTypes.default.oneOfType([_propTypes.default.any.isRequired, _propTypes.default.oneOf(["none"])]),
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any
};