"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.POSITIONS = exports.EuiToolTip = exports.DEFAULT_TOOLTIP_OFFSET = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../services");
var _reposition_on_scroll = require("../../services/popover/reposition_on_scroll");
var _react2 = require("../../services/react");
var _resize_observer = require("../observer/resize_observer");
var _portal = require("../portal");
var _component_defaults = require("../provider/component_defaults");
var _tool_tip_popover = require("./tool_tip_popover");
var _tool_tip_anchor = require("./tool_tip_anchor");
var _tool_tip_arrow = require("./tool_tip_arrow");
var _tool_tip_manager = require("./tool_tip_manager");
var _react3 = require("@emotion/react");
var _excluded = ["children", "className", "anchorClassName", "anchorProps", "content", "title", "delay", "display", "repositionOnScroll", "disableScreenReaderOutput"];
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var POSITIONS = exports.POSITIONS = ['top', 'right', 'bottom', 'left'];
var DISPLAYS = ['inlineBlock', 'block'];
var DEFAULT_TOOLTIP_OFFSET = exports.DEFAULT_TOOLTIP_OFFSET = 16;
var delayToMsMap = {
  regular: 250,
  long: 250 * 5
};
var DEFAULT_TOOLTIP_STYLES = {
  // position the tooltip content near the top-left
  // corner of the window so it can't create scrollbars
  // 50,50 because who knows what negative margins, padding, etc
  top: 50,
  left: 50,
  // just in case, avoid any potential flicker by hiding
  // the tooltip before it is positioned
  opacity: 0,
  // prevent accidental mouse interaction while positioning
  visibility: 'hidden'
};
var EuiToolTip = exports.EuiToolTip = /*#__PURE__*/function (_Component) {
  function EuiToolTip(props) {
    var _this;
    _classCallCheck(this, EuiToolTip);
    _this = _callSuper(this, EuiToolTip, [props]);
    _defineProperty(_this, "repositionOnScroll", void 0);
    _defineProperty(_this, "_isMounted", false);
    _defineProperty(_this, "anchor", null);
    _defineProperty(_this, "popover", null);
    _defineProperty(_this, "timeoutId", void 0);
    _defineProperty(_this, "clearAnimationTimeout", function () {
      if (_this.timeoutId) {
        _this.timeoutId = clearTimeout(_this.timeoutId);
      }
    });
    _defineProperty(_this, "testAnchor", function () {
      // when the tooltip is visible, this checks if the anchor is still part of document
      // this fixes when the react root is removed from the dom without unmounting
      // https://github.com/elastic/eui/issues/1105
      if (document.body.contains(_this.anchor) === false) {
        // the anchor is no longer part of `document`
        _this.hideToolTip();
      } else {
        if (_this.state.visible) {
          // if still visible, keep checking
          requestAnimationFrame(_this.testAnchor);
        }
      }
    });
    _defineProperty(_this, "setAnchorRef", function (ref) {
      return _this.anchor = ref;
    });
    _defineProperty(_this, "setPopoverRef", function (ref) {
      return _this.popover = ref;
    });
    _defineProperty(_this, "showToolTip", function () {
      if (!_this.timeoutId) {
        _this.timeoutId = setTimeout(function () {
          (0, _react2.enqueueStateChange)(function () {
            _this.setState({
              visible: true
            });
            _tool_tip_manager.toolTipManager.registerTooltip(_this.hideToolTip);
          });
        }, delayToMsMap[_this.props.delay]);
      }
    });
    _defineProperty(_this, "positionToolTip", function () {
      var _this$props$offset;
      var requestedPosition = _this.props.position;
      var offset = (_this$props$offset = _this.props.offset) !== null && _this$props$offset !== void 0 ? _this$props$offset : DEFAULT_TOOLTIP_OFFSET;
      if (!_this.anchor || !_this.popover) {
        return;
      }
      var _findPopoverPosition = (0, _services.findPopoverPosition)({
          anchor: _this.anchor,
          popover: _this.popover,
          position: requestedPosition,
          offset: offset,
          arrowConfig: {
            arrowWidth: 12,
            arrowBuffer: 4
          }
        }),
        position = _findPopoverPosition.position,
        left = _findPopoverPosition.left,
        top = _findPopoverPosition.top,
        arrow = _findPopoverPosition.arrow;

      // If encroaching the right edge of the window:
      // When `props.content` changes and is longer than `prevProps.content`, the tooltip width remains and
      // the resizeObserver callback will fire twice (once for vertical resize caused by text line wrapping,
      // once for a subsequent position correction) and cause a flash rerender and reposition.
      // To prevent this, we can orient from the right so that text line wrapping does not occur, negating
      // the second resizeObserver callback call.
      var windowWidth = document.documentElement.clientWidth || window.innerWidth;
      var useRightValue = windowWidth / 2 < left;
      var toolTipStyles = {
        top: top,
        left: useRightValue ? 'auto' : left,
        right: useRightValue ? windowWidth - left - _this.popover.offsetWidth : 'auto'
      };
      _this.setState({
        visible: true,
        calculatedPosition: position,
        toolTipStyles: toolTipStyles,
        arrowStyles: arrow
      });
    });
    _defineProperty(_this, "hideToolTip", function () {
      _this.clearAnimationTimeout();
      (0, _react2.enqueueStateChange)(function () {
        if (_this._isMounted) {
          _this.setState({
            visible: false,
            toolTipStyles: DEFAULT_TOOLTIP_STYLES,
            arrowStyles: undefined
          });
          _tool_tip_manager.toolTipManager.deregisterToolTip(_this.hideToolTip);
        }
      });
    });
    _defineProperty(_this, "onFocus", function () {
      _this.setState({
        hasFocus: true
      });
      _this.showToolTip();
    });
    _defineProperty(_this, "onBlur", function () {
      _this.setState({
        hasFocus: false
      });
      _this.hideToolTip();
    });
    _defineProperty(_this, "onEscapeKey", function (event) {
      if (event.key === _services.keys.ESCAPE) {
        // when the tooltip is only visual, we don't want it to add an additional key stop
        if (!_this.props.disableScreenReaderOutput) {
          if (_this.state.visible) event.stopPropagation();
        }
        _this.setState({
          hasFocus: false
        }); // Allows mousing over back into the tooltip to work correctly
        _this.hideToolTip();
      }
    });
    _defineProperty(_this, "onMouseOut", function (event) {
      // Prevent mousing over children from hiding the tooltip by testing for whether the mouse has
      // left the anchor for a non-child.
      if (_this.anchor === event.relatedTarget || _this.anchor != null && !_this.anchor.contains(event.relatedTarget)) {
        if (!_this.state.hasFocus) {
          _this.hideToolTip();
        }
      }
      if (_this.props.onMouseOut) {
        _this.props.onMouseOut(event);
      }
    });
    _this.state = {
      visible: false,
      hasFocus: false,
      calculatedPosition: _this.props.position,
      toolTipStyles: DEFAULT_TOOLTIP_STYLES,
      arrowStyles: undefined,
      id: _this.props.id || (0, _services.htmlIdGenerator)()()
    };
    _this.repositionOnScroll = (0, _reposition_on_scroll.createRepositionOnScroll)(function () {
      return {
        repositionOnScroll: _this.props.repositionOnScroll,
        componentDefaults: _this.context.EuiToolTip,
        repositionFn: _this.positionToolTip
      };
    });
    return _this;
  }
  _inherits(EuiToolTip, _Component);
  return _createClass(EuiToolTip, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      this._isMounted = true;
      this.repositionOnScroll.subscribe();
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      this.clearAnimationTimeout();
      this._isMounted = false;
      this.repositionOnScroll.cleanup();
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps, prevState) {
      if (prevState.visible === false && this.state.visible === true) {
        requestAnimationFrame(this.testAnchor);
      }

      // update scroll listener
      this.repositionOnScroll.update();
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props = this.props,
        children = _this$props.children,
        className = _this$props.className,
        anchorClassName = _this$props.anchorClassName,
        anchorProps = _this$props.anchorProps,
        content = _this$props.content,
        title = _this$props.title,
        delay = _this$props.delay,
        display = _this$props.display,
        repositionOnScroll = _this$props.repositionOnScroll,
        _this$props$disableSc = _this$props.disableScreenReaderOutput,
        disableScreenReaderOutput = _this$props$disableSc === void 0 ? false : _this$props$disableSc,
        rest = _objectWithoutProperties(_this$props, _excluded);
      var _this$state = this.state,
        arrowStyles = _this$state.arrowStyles,
        id = _this$state.id,
        toolTipStyles = _this$state.toolTipStyles,
        visible = _this$state.visible,
        calculatedPosition = _this$state.calculatedPosition;
      var classes = (0, _classnames.default)('euiToolTip', className);
      var anchorClasses = (0, _classnames.default)(anchorClassName, anchorProps === null || anchorProps === void 0 ? void 0 : anchorProps.className);
      return (0, _react3.jsx)(_react.default.Fragment, null, (0, _react3.jsx)(_tool_tip_anchor.EuiToolTipAnchor, _extends({}, anchorProps, {
        ref: this.setAnchorRef,
        onBlur: this.onBlur,
        onFocus: this.onFocus,
        onKeyDown: this.onEscapeKey,
        onMouseOver: this.showToolTip,
        onMouseOut: this.onMouseOut
        // `id` defines if the trigger and tooltip are automatically linked via `aria-describedby`.
        ,
        id: !disableScreenReaderOutput ? id : undefined,
        className: anchorClasses,
        display: display,
        isVisible: visible
      }), children), visible && (content || title) && (0, _react3.jsx)(_portal.EuiPortal, null, (0, _react3.jsx)(_tool_tip_popover.EuiToolTipPopover, _extends({
        className: classes,
        style: toolTipStyles,
        positionToolTip: this.positionToolTip,
        popoverRef: this.setPopoverRef,
        title: title,
        id: id,
        role: "tooltip",
        calculatedPosition: calculatedPosition
      }, rest), (0, _react3.jsx)(_tool_tip_arrow.EuiToolTipArrow, {
        style: arrowStyles,
        className: "euiToolTip__arrow",
        position: calculatedPosition
      }), (0, _react3.jsx)(_resize_observer.EuiResizeObserver, {
        onResize: this.positionToolTip
      }, function (resizeRef) {
        return (0, _react3.jsx)("div", {
          ref: resizeRef
        }, content);
      }))));
    }
  }]);
}(_react.Component);
_defineProperty(EuiToolTip, "contextType", _component_defaults.EuiComponentDefaultsContext);
_defineProperty(EuiToolTip, "defaultProps", {
  position: 'top',
  delay: 'regular',
  display: 'inlineBlock',
  disableScreenReaderOutput: false
});
EuiToolTip.propTypes = {
  /**
     * Passes onto the span wrapping the trigger.
     */
  anchorClassName: _propTypes.default.string,
  /**
     * Passes onto the span wrapping the trigger.
     */
  anchorProps: _propTypes.default.shape({
    className: _propTypes.default.string,
    "aria-label": _propTypes.default.string,
    "data-test-subj": _propTypes.default.string,
    css: _propTypes.default.any
  }),
  /**
     * The in-view trigger for your tooltip.
     */
  children: _propTypes.default.element.isRequired,
  /**
     * Passes onto the tooltip itself, not the trigger.
     */
  className: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.string]),
  /**
     * The main content of your tooltip.
     */
  content: _propTypes.default.node,
  /**
     * Common display alternatives for the anchor wrapper
     */
  display: _propTypes.default.any,
  /**
     * Delay before showing tooltip. Good for repeatable items.
     */
  delay: _propTypes.default.oneOf(["regular", "long"]).isRequired,
  /**
     * An optional title for your tooltip.
     */
  title: _propTypes.default.node,
  /**
     * Unless you provide one, this will be randomly generated.
     */
  id: _propTypes.default.string,
  /**
     * Suggested position. If there is not enough room for it this will be changed.
     */
  position: _propTypes.default.oneOf(["top", "right", "bottom", "left"]).isRequired,
  /**
     * When `true`, the tooltip's position is re-calculated when the user
     * scrolls. This supports having fixed-position tooltip anchors.
     *
     * When nesting an `EuiTooltip` in a scrollable container, `repositionOnScroll` should be `true`
     */
  repositionOnScroll: _propTypes.default.bool,
  /**
     * Disables the tooltip content being read by screen readers when focusing the trigger element.
     * Do not use when the trigger `aria-label` and tooltip `content` can be rephrased to be standalone
     * information (action & additional information).
     * Enable this prop only when the trigger has a descriptive label that either duplicates or includes
     * the tooltip content and would result in repetitive output.
     * @default false
     */
  disableScreenReaderOutput: _propTypes.default.bool,
  /**
     * If supplied, called when mouse movement causes the tool tip to be
     * hidden.
     */
  onMouseOut: _propTypes.default.func,
  /**
     * Offset in pixels from the anchor. Defaults to 16.
     */
  offset: _propTypes.default.number,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any
};