"use strict";

var _react = _interopRequireDefault(require("react"));
var _tree_view = require("./tree_view");
var _react2 = require("@emotion/react");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/// <reference types="cypress" />
/// <reference types="cypress-real-events" />
/// <reference types="../../../cypress/support" />

var TreeView = function TreeView() {
  var items = [{
    label: 'Item One',
    id: 'item_one',
    isExpanded: true,
    children: [{
      label: 'Item A',
      id: 'item_a'
    }, {
      label: 'Item B',
      id: 'item_b',
      children: [{
        label: 'A Cloud',
        id: 'item_cloud'
      }, {
        label: "I'm a Bug",
        id: 'item_bug',
        className: 'classForBug'
      }]
    }, {
      label: 'Item C',
      id: 'item_c',
      children: [{
        label: 'Another Cloud',
        id: 'item_cloud2'
      }, {
        label: 'Another Bug',
        id: 'item_bug2'
      }]
    }]
  }, {
    label: 'Item Two',
    id: 'item_two'
  }];
  var defaultTreeViewProps = {
    items: items,
    'aria-label': 'Sample folder tree'
  };
  return (0, _react2.jsx)("div", {
    style: {
      width: '20rem'
    }
  }, (0, _react2.jsx)(_tree_view.EuiTreeView, defaultTreeViewProps));
};
describe('EuiTreeView', function () {
  describe('Automated accessibility check', function () {
    it('has zero violations on first render', function () {
      cy.mount((0, _react2.jsx)(TreeView, null));
      cy.get('ul.euiTreeView').should('exist');
      cy.checkAxe();
    });
    it('has zero violations with a nested child expanded', function () {
      cy.mount((0, _react2.jsx)(TreeView, null));
      cy.get('ul.euiTreeView').should('exist');
      cy.get('button#item_b').realClick();
      cy.get('button#item_b').should('have.attr', 'aria-expanded', 'true');
      cy.get('li.euiTreeView__node').contains('A Cloud').should('exist');
      cy.checkAxe();
    });
  });
});