"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useEuiThemeRefreshVariant = exports.isEuiThemeRefreshVariant = void 0;
var _hooks = require("./hooks");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var isEuiThemeRefreshVariant = exports.isEuiThemeRefreshVariant = function isEuiThemeRefreshVariant(_ref, flag) {
  var euiTheme = _ref.euiTheme;
  return euiTheme.flags[flag] === 'refresh';
};

/**
 * Util to retrieve visual variant for UI elements
 * Note: Temporary only - will be removed once the visual refresh is completed.
 */
var useEuiThemeRefreshVariant = exports.useEuiThemeRefreshVariant = function useEuiThemeRefreshVariant(flag) {
  var euiThemeContext = (0, _hooks.useEuiTheme)();
  return isEuiThemeRefreshVariant(euiThemeContext, flag);
};