"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SnapshotManager = void 0;
const InversifyContainerError_1 = require("../../error/models/InversifyContainerError");
const InversifyContainerErrorKind_1 = require("../../error/models/InversifyContainerErrorKind");
class SnapshotManager {
    #serviceReferenceManager;
    #snapshots;
    constructor(serviceReferenceManager) {
        this.#serviceReferenceManager = serviceReferenceManager;
        this.#snapshots = [];
    }
    restore() {
        const snapshot = this.#snapshots.pop();
        if (snapshot === undefined) {
            throw new InversifyContainerError_1.InversifyContainerError(InversifyContainerErrorKind_1.InversifyContainerErrorKind.invalidOperation, 'No snapshot available to restore');
        }
        this.#serviceReferenceManager.reset(snapshot.activationService, snapshot.bindingService, snapshot.deactivationService);
    }
    snapshot() {
        this.#snapshots.push({
            activationService: this.#serviceReferenceManager.activationService.clone(),
            bindingService: this.#serviceReferenceManager.bindingService.clone(),
            deactivationService: this.#serviceReferenceManager.deactivationService.clone(),
        });
    }
}
exports.SnapshotManager = SnapshotManager;
//# sourceMappingURL=SnapshotManager.js.map