"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SingleImmutableLinkedList = void 0;
class SingleImmutableLinkedList {
    last;
    constructor(last) {
        this.last = last;
    }
    concat(elem) {
        return new SingleImmutableLinkedList({
            elem,
            previous: this.last,
        });
    }
    [Symbol.iterator]() {
        let node = this.last;
        return {
            next: () => {
                if (node === undefined) {
                    return {
                        done: true,
                        value: undefined,
                    };
                }
                const elem = node.elem;
                node = node.previous;
                return {
                    done: false,
                    value: elem,
                };
            },
        };
    }
}
exports.SingleImmutableLinkedList = SingleImmutableLinkedList;
//# sourceMappingURL=SingleImmutableLinkedList.js.map