"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.buildFilteredServiceBindings = buildFilteredServiceBindings;
const getBindingId_1 = require("../../binding/actions/getBindingId");
const BindingType_1 = require("../../binding/models/BindingType");
const getClassMetadata_1 = require("../../metadata/calculations/getClassMetadata");
function buildFilteredServiceBindings(params, bindingConstraints, options) {
    const serviceIdentifier = options?.customServiceIdentifier ?? bindingConstraints.serviceIdentifier;
    const serviceBindings = options?.chained === true
        ? [...params.operations.getBindingsChained(serviceIdentifier)]
        : [...(params.operations.getBindings(serviceIdentifier) ?? [])];
    const filteredBindings = serviceBindings.filter((binding) => binding.isSatisfiedBy(bindingConstraints));
    if (filteredBindings.length === 0 &&
        params.autobindOptions !== undefined &&
        typeof serviceIdentifier === 'function') {
        const binding = buildInstanceBinding(params.autobindOptions, serviceIdentifier);
        params.operations.setBinding(binding);
        filteredBindings.push(binding);
    }
    return filteredBindings;
}
function buildInstanceBinding(autobindOptions, serviceIdentifier) {
    const classMetadata = (0, getClassMetadata_1.getClassMetadata)(serviceIdentifier);
    const scope = classMetadata.scope ?? autobindOptions.scope;
    return {
        cache: {
            isRight: false,
            value: undefined,
        },
        id: (0, getBindingId_1.getBindingId)(),
        implementationType: serviceIdentifier,
        isSatisfiedBy: () => true,
        moduleId: undefined,
        onActivation: undefined,
        onDeactivation: undefined,
        scope,
        serviceIdentifier,
        type: BindingType_1.bindingTypeValues.Instance,
    };
}
//# sourceMappingURL=buildFilteredServiceBindings.js.map