"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LazyPlanServiceNode = void 0;
const isLazyPlanServiceNodeSymbol = Symbol.for('@inversifyjs/core/LazyPlanServiceNode');
class LazyPlanServiceNode {
    [isLazyPlanServiceNodeSymbol];
    _serviceIdentifier;
    _serviceNode;
    constructor(serviceNode, serviceIdentifier) {
        this[isLazyPlanServiceNodeSymbol] = true;
        this._serviceNode = serviceNode;
        this._serviceIdentifier = serviceIdentifier;
    }
    get bindings() {
        return this._getNode().bindings;
    }
    get isContextFree() {
        return this._getNode().isContextFree;
    }
    get serviceIdentifier() {
        return this._serviceIdentifier;
    }
    set bindings(bindings) {
        this._getNode().bindings = bindings;
    }
    set isContextFree(isContextFree) {
        this._getNode().isContextFree = isContextFree;
    }
    static is(value) {
        return (typeof value === 'object' &&
            value !== null &&
            value[isLazyPlanServiceNodeSymbol] ===
                true);
    }
    invalidate() {
        this._serviceNode = undefined;
    }
    isExpanded() {
        return this._serviceNode !== undefined;
    }
    _getNode() {
        if (this._serviceNode === undefined) {
            this._serviceNode = this._buildPlanServiceNode();
        }
        return this._serviceNode;
    }
}
exports.LazyPlanServiceNode = LazyPlanServiceNode;
//# sourceMappingURL=LazyPlanServiceNode.js.map