"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.resolveBindingServiceActivations = resolveBindingServiceActivations;
const common_1 = require("@inversifyjs/common");
function resolveBindingServiceActivations(params, serviceIdentifier, value) {
    const activations = params.getActivations(serviceIdentifier);
    if (activations === undefined) {
        return value;
    }
    if ((0, common_1.isPromise)(value)) {
        return resolveBindingActivationsFromIteratorAsync(params, value, activations[Symbol.iterator]());
    }
    return resolveBindingActivationsFromIterator(params, value, activations[Symbol.iterator]());
}
function resolveBindingActivationsFromIterator(params, value, activationsIterator) {
    let activatedValue = value;
    let activationIteratorResult = activationsIterator.next();
    while (activationIteratorResult.done !== true) {
        const nextActivatedValue = activationIteratorResult.value(params.context, activatedValue);
        if ((0, common_1.isPromise)(nextActivatedValue)) {
            return resolveBindingActivationsFromIteratorAsync(params, nextActivatedValue, activationsIterator);
        }
        else {
            activatedValue = nextActivatedValue;
        }
        activationIteratorResult = activationsIterator.next();
    }
    return activatedValue;
}
async function resolveBindingActivationsFromIteratorAsync(params, value, activationsIterator) {
    let activatedValue = await value;
    let activationIteratorResult = activationsIterator.next();
    while (activationIteratorResult.done !== true) {
        activatedValue = await activationIteratorResult.value(params.context, activatedValue);
        activationIteratorResult = activationsIterator.next();
    }
    return activatedValue;
}
//# sourceMappingURL=resolveBindingServiceActivations.js.map