"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.httpResponseUserErrorCodes = exports.createAndThrowUserError = void 0;
var _server = require("@kbn/task-manager-plugin/server");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const httpResponseUserErrorCodes = exports.httpResponseUserErrorCodes = [401, 402, 403, 407, 409, 412, 413, 417, 422, 423, 429, 451];

/**
 * Categorizes errored actions HTTP requests against external systems, creating user errors based
 * on the status code of the response and any overrides provided.
 */
const createAndThrowUserError = error => {
  var _error$response;
  const statusCode = (_error$response = error.response) === null || _error$response === void 0 ? void 0 : _error$response.status;
  if (statusCode != null) {
    if (httpResponseUserErrorCodes.includes(Number(statusCode))) {
      throw (0, _server.createTaskRunError)(error, _server.TaskErrorSource.USER);
    }
  }
};
exports.createAndThrowUserError = createAndThrowUserError;