"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createConnectorTypeFromSpec = void 0;
var _actionsTypes = require("@kbn/actions-types");
var _generate_params_schema = require("./generate_params_schema");
var _generate_secrets_schema = require("./generate_secrets_schema");
var _generate_executor_function = require("./generate_executor_function");
var _generate_config_schema = require("./generate_config_schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createConnectorTypeFromSpec = (spec, actions) => {
  var _spec$auth;
  const configUtils = actions.getActionsConfigurationUtilities();
  const executor = (0, _generate_executor_function.generateExecutorFunction)({
    actions: spec.actions,
    getAxiosInstanceWithAuth: actions.getAxiosInstanceWithAuth
  });
  return {
    id: spec.metadata.id,
    minimumLicenseRequired: spec.metadata.minimumLicense,
    name: spec.metadata.displayName,
    supportedFeatureIds: spec.metadata.supportedFeatureIds,
    validate: {
      config: (0, _generate_config_schema.generateConfigSchema)(spec.schema),
      secrets: (0, _generate_secrets_schema.generateSecretsSchema)(spec.auth, configUtils),
      params: (0, _generate_params_schema.generateParamsSchema)(spec.actions)
    },
    executor,
    globalAuthHeaders: (_spec$auth = spec.auth) === null || _spec$auth === void 0 ? void 0 : _spec$auth.headers,
    source: _actionsTypes.ACTION_TYPE_SOURCES.spec
  };
};
exports.createConnectorTypeFromSpec = createConnectorTypeFromSpec;