"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.generateConfigSchema = void 0;
var _v = require("@kbn/zod/v4");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const generateConfigSchema = schema => {
  const authType = _v.z.string().optional();
  const configSchema = schema ? schema.extend({
    authType
  }) : _v.z.object({
    authType
  });
  return {
    schema: configSchema
  };
};
exports.generateConfigSchema = generateConfigSchema;