"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.defineRoutes = defineRoutes;
var _get_all = require("./connector/get_all");
var _get_all_system = require("./connector/get_all_system");
var _list_types = require("./connector/list_types");
var _list_types_system = require("./connector/list_types_system");
var _create = require("./connector/create");
var _delete = require("./connector/delete");
var _execute = require("./connector/execute");
var _get = require("./connector/get");
var _update = require("./connector/update");
var _get_oauth_access_token = require("./get_oauth_access_token");
var _get_global_execution_logs = require("./get_global_execution_logs");
var _get_global_execution_kpi = require("./get_global_execution_kpi");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function defineRoutes(opts) {
  const {
    router,
    licenseState,
    actionsConfigUtils
  } = opts;
  (0, _create.createConnectorRoute)(router, licenseState);
  (0, _delete.deleteConnectorRoute)(router, licenseState);
  (0, _get.getConnectorRoute)(router, licenseState);
  (0, _get_all.getAllConnectorsRoute)(router, licenseState);
  (0, _update.updateConnectorRoute)(router, licenseState);
  (0, _list_types.listTypesRoute)(router, licenseState);
  (0, _execute.executeConnectorRoute)(router, licenseState);
  (0, _get_global_execution_logs.getGlobalExecutionLogRoute)(router, licenseState);
  (0, _get_global_execution_kpi.getGlobalExecutionKPIRoute)(router, licenseState);
  (0, _get_oauth_access_token.getOAuthAccessToken)(router, licenseState, actionsConfigUtils);
  (0, _get_all_system.getAllConnectorsIncludingSystemRoute)(router, licenseState);
  (0, _list_types_system.listTypesWithSystemRoute)(router, licenseState);
}