"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createScreenContextAttachmentType = void 0;
var _attachments = require("@kbn/onechat-common/attachments");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Creates the definition for the `screen_context` attachment type.
 */
const createScreenContextAttachmentType = () => {
  return {
    id: _attachments.AttachmentType.screenContext,
    validate: input => {
      const parseResult = _attachments.screenContextAttachmentDataSchema.safeParse(input);
      if (parseResult.success) {
        return {
          valid: true,
          data: parseResult.data
        };
      } else {
        return {
          valid: false,
          error: parseResult.error.message
        };
      }
    },
    format: attachment => {
      return {
        getRepresentation: () => {
          return {
            type: 'text',
            value: formatScreenContext(attachment.data)
          };
        }
      };
    },
    getTools: () => []
  };
};
exports.createScreenContextAttachmentType = createScreenContextAttachmentType;
const formatScreenContext = data => {
  const parts = [];
  if (data.app) {
    parts.push(`App: ${data.app}`);
  }
  if (data.url) {
    parts.push(`Url: ${data.url}`);
  }
  if (data.description) {
    parts.push(`Description: ${data.description}`);
  }
  if (data.additional_data) {
    parts.push(`Additional data: ${JSON.stringify(data.additional_data)}`);
  }
  return parts.join('\n');
};