"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.filterScopes = filterScopes;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function filterScopes(scopeFilters) {
  return function (value) {
    if (!scopeFilters || !value) {
      return true;
    }
    return value !== null && value !== void 0 && value.scopes ? value.scopes.some(scope => [...scopeFilters, 'all'].includes(scope)) : true;
  };
}