"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AIAssistantHeaderButton = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _aiAssistantIcon = require("@kbn/ai-assistant-icon");
var _aiAssistantCommon = require("@kbn/ai-assistant-common");
var _aiAgentConfirmationModal = require("@kbn/ai-agent-confirmation-modal");
var _ui_setting_keys = require("../../../common/ui_setting_keys");
var _ai_assistant_type = require("../../../common/ai_assistant_type");
var _assistant_icon = require("../../icons/assistant_icon/assistant_icon");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769677912408185922/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/ai_assistant_management/selection/public/components/navigation_control/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AIAssistantHeaderButton = ({
  coreStart,
  isSecurityAIAssistantEnabled,
  isObservabilityAIAssistantEnabled,
  triggerOpenChat
}) => {
  var _coreStart$applicatio;
  const [isModalOpen, setModalOpen] = (0, _react.useState)(false);
  const [isConfirmModalOpen, setConfirmModalOpen] = (0, _react.useState)(false);
  const {
    getUrlForApp
  } = coreStart.application;
  const {
    toasts
  } = coreStart.notifications;
  const {
    links: docLinks
  } = coreStart.docLinks;
  const hasAgentBuilder = ((_coreStart$applicatio = coreStart.application.capabilities.agentBuilder) === null || _coreStart$applicatio === void 0 ? void 0 : _coreStart$applicatio.manageAgents) === true;
  const [selectedType, setSelectedType] = (0, _react.useState)(_ai_assistant_type.AIAssistantType.Default);
  const onModalClose = (0, _react.useCallback)(() => {
    setModalOpen(false);
    setSelectedType(_ai_assistant_type.AIAssistantType.Default);
  }, []);
  const modalTitleId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'aiAssistantModalTitle'
  });
  const applySelection = (0, _react.useCallback)(async () => {
    const chatExperience = selectedType === _aiAssistantCommon.AIChatExperience.Agent ? _aiAssistantCommon.AIChatExperience.Agent : _aiAssistantCommon.AIChatExperience.Classic;
    const assistant = selectedType === _aiAssistantCommon.AIChatExperience.Agent ? _ai_assistant_type.AIAssistantType.Default : selectedType;
    try {
      await Promise.all([coreStart.settings.client.set(_ui_setting_keys.PREFERRED_AI_ASSISTANT_TYPE_SETTING_KEY, assistant), coreStart.settings.client.set(_ui_setting_keys.PREFERRED_CHAT_EXPERIENCE_SETTING_KEY, chatExperience)]);
      triggerOpenChat(selectedType);
    } catch (error) {
      var _error$body;
      toasts.addError(new Error(((_error$body = error.body) === null || _error$body === void 0 ? void 0 : _error$body.message) || error.message || 'Unknown error occurred'), {
        title: _i18n.i18n.translate('aiAssistantManagementSelection.headerButton.settingsSaveErrorTitle', {
          defaultMessage: 'Failed to apply AI assistant settings'
        })
      });
    }
  }, [coreStart.settings.client, selectedType, triggerOpenChat, toasts]);
  const handleConfirmAgent = (0, _react.useCallback)(async () => {
    setConfirmModalOpen(false);
    setModalOpen(false);
    await applySelection();
  }, [applySelection]);
  const onApply = (0, _react.useCallback)(async () => {
    if (selectedType === _aiAssistantCommon.AIChatExperience.Agent) {
      setConfirmModalOpen(true);
    } else {
      setModalOpen(false);
      await applySelection();
    }
  }, [selectedType, applySelection]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    iconType: _assistant_icon.AssistantIcon,
    onClick: () => setModalOpen(true),
    "data-test-subj": "aiAssistantHeaderButton",
    "aria-label": _i18n.i18n.translate('aiAssistantManagementSelection.headerButton.ariaLabel', {
      defaultMessage: 'Open the AI Assistant selector'
    }),
    color: "primary",
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 7
    }
  }, _i18n.i18n.translate('aiAssistantManagementSelection.headerButton.label', {
    defaultMessage: 'AI Assistant'
  })), isModalOpen && /*#__PURE__*/_react.default.createElement(_eui.EuiOverlayMask, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    onClose: onModalClose,
    "aria-labelledby": modalTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
    id: modalTitleId,
    "data-test-subj": "aiAssistantModalTitle",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('aiAssistantManagementSelection.headerButton.selectAIChatExperienceTitle', {
    defaultMessage: 'Select a chat experience'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "aiAssistantManagementSelection.headerButton.description",
    defaultMessage: 'Choose which chat experience to use throughout Kibana. {learnMoreLink}. <bold>This setting applies to all users in the space.</bold> To change it later, go to {genAiSettings}.',
    values: {
      bold: str => /*#__PURE__*/_react.default.createElement("strong", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 148,
          columnNumber: 36
        }
      }, str),
      genAiSettings: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "navigateToGenAISettings",
        href: getUrlForApp('management', {
          path: '/ai/genAiSettings'
        }),
        target: "_blank",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 150,
          columnNumber: 23
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "aiAssistantManagementSelection.assistants.control.navigateToGenAiSettings",
        defaultMessage: 'GenAI Settings',
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 155,
          columnNumber: 25
        }
      })),
      learnMoreLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: docLinks.agentBuilder.learnMore,
        target: "_blank",
        "data-test-subj": "aiAgentBuilderLearnMoreLink",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 162,
          columnNumber: 23
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "aiAssistantManagementSelection.headerButton.learnMoreLink",
        defaultMessage: "Learn more",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 167,
          columnNumber: 25
        }
      }))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 142,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 176,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 177,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 178,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    display: "plain",
    hasBorder: true,
    selectable: {
      isSelected: selectedType === _ai_assistant_type.AIAssistantType.Observability,
      onClick: () => setSelectedType(_ai_assistant_type.AIAssistantType.Observability)
    },
    title: _i18n.i18n.translate('aiAssistantManagementSelection.headerButton.observabilityLabel', {
      defaultMessage: 'Observability and Search AI Assistant'
    }),
    titleSize: "xs",
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "m",
      alignItems: "center",
      responsive: false,
      direction: "row",
      justifyContent: "center",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 194,
        columnNumber: 23
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 201,
        columnNumber: 25
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "xxl",
      type: "logoObservability",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 202,
        columnNumber: 27
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 204,
        columnNumber: 25
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "xxl",
      type: "logoEnterpriseSearch",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 205,
        columnNumber: 27
      }
    }))),
    "data-test-subj": "aiAssistantObservabilityCard",
    isDisabled: !isObservabilityAIAssistantEnabled,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 179,
      columnNumber: 19
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 213,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    display: "plain",
    hasBorder: true,
    selectable: {
      isSelected: selectedType === _ai_assistant_type.AIAssistantType.Security,
      onClick: () => setSelectedType(_ai_assistant_type.AIAssistantType.Security)
    },
    title: _i18n.i18n.translate('aiAssistantManagementSelection.headerButton.securityLabel', {
      defaultMessage: 'Security AI Assistant'
    }),
    titleSize: "xs",
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "xxl",
      type: "logoSecurity",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 228,
        columnNumber: 27
      }
    }),
    "data-test-subj": "aiAssistantSecurityCard",
    isDisabled: !isSecurityAIAssistantEnabled,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 214,
      columnNumber: 19
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 233,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    display: "plain",
    hasBorder: true,
    betaBadgeProps: {
      label: _i18n.i18n.translate('aiAssistantManagementSelection.headerButton.betaLabel', {
        defaultMessage: 'BETA'
      })
    },
    selectable: {
      isSelected: selectedType === _aiAssistantCommon.AIChatExperience.Agent,
      onClick: () => setSelectedType(_aiAssistantCommon.AIChatExperience.Agent)
    },
    title: _i18n.i18n.translate('aiAssistantManagementSelection.headerButton.aiAgentLabel', {
      defaultMessage: 'AI Agent'
    }),
    titleSize: "xs",
    icon: /*#__PURE__*/_react.default.createElement(_aiAssistantIcon.RobotIcon, {
      size: "xxl",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 256,
        columnNumber: 27
      }
    }),
    "data-test-subj": "aiAssistantAgentCard",
    isDisabled: !hasAgentBuilder,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 234,
      columnNumber: 19
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 263,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    gutterSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 264,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 265,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "text",
    onClick: onModalClose,
    "data-test-subj": "aiAssistantCancelButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 266,
      columnNumber: 19
    }
  }, _i18n.i18n.translate('aiAssistantManagementSelection.headerButton.cancelLabel', {
    defaultMessage: 'Cancel'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 276,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: onApply,
    fill: true,
    isDisabled: selectedType === _ai_assistant_type.AIAssistantType.Default,
    "data-test-subj": "aiAssistantApplyButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 277,
      columnNumber: 19
    }
  }, _i18n.i18n.translate('aiAssistantManagementSelection.headerButton.applyLabel', {
    defaultMessage: 'Continue'
  }))))))), isConfirmModalOpen && /*#__PURE__*/_react.default.createElement(_aiAgentConfirmationModal.AIAgentConfirmationModal, {
    onConfirm: handleConfirmAgent,
    onCancel: () => setConfirmModalOpen(false),
    docLinks: docLinks,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 295,
      columnNumber: 9
    }
  }));
};
exports.AIAssistantHeaderButton = AIAssistantHeaderButton;