"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.classicSetting = void 0;
var _i18n = require("@kbn/i18n");
var _configSchema = require("@kbn/config-schema");
var _ai_assistant_type = require("../../../common/ai_assistant_type");
var _translations = require("./translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

// Define the classicSetting with proper typing
const classicSetting = exports.classicSetting = {
  name: _translations.AI_ASSISTANT_VISIBILITY_TITLE,
  description: _i18n.i18n.translate('aiAssistantManagementSelection.preferredAIAssistantTypeSettingDescription', {
    defaultMessage: 'Configure AI Assistant availability for each solution. You can make them appear only in their own solutions, make a specific one appear throughout Kibana, or hide them completely.'
  }),
  schema: _configSchema.schema.oneOf([_configSchema.schema.literal(_ai_assistant_type.AIAssistantType.Default), _configSchema.schema.literal(_ai_assistant_type.AIAssistantType.Observability), _configSchema.schema.literal(_ai_assistant_type.AIAssistantType.Security), _configSchema.schema.literal(_ai_assistant_type.AIAssistantType.Never)], {
    defaultValue: _ai_assistant_type.AIAssistantType.Default
  }),
  options: [_ai_assistant_type.AIAssistantType.Default, _ai_assistant_type.AIAssistantType.Observability, _ai_assistant_type.AIAssistantType.Security, _ai_assistant_type.AIAssistantType.Never],
  type: 'select',
  optionLabels: {
    [_ai_assistant_type.AIAssistantType.Default]: _translations.ONLY_IN_THEIR_SOLUTIONS,
    [_ai_assistant_type.AIAssistantType.Observability]: _translations.OBSERVABILITY_IN_OTHER_APPS,
    [_ai_assistant_type.AIAssistantType.Security]: _translations.SECURITY_IN_OTHER_APPS,
    [_ai_assistant_type.AIAssistantType.Never]: _translations.HIDE_ALL_ASSISTANTS
  },
  requiresPageReload: true,
  solutionViews: ['classic'],
  // Hide the setting in Kibana -> Advanced Settigns
  readonly: true,
  readonlyMode: 'ui'
};